package com.artfess.manage.duty.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;

import java.util.List;
import java.util.Map;

/**
 * 勤务队员信息 服务类
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
public interface CmgtDutyTeamMemberManager extends BaseManager<CmgtDutyTeamMember> {

    /**
     * 根据小组id查询小组所在部门的所有队员信息
     *
     * @param teamid
     * @return
     */
    List<Map<String, Object>> findAllMembersByTeamId(String teamid);

    /**
     * 查询未分组的队员信息
     *
     * @param orgId
     * @return
     */
    public List<Map<String, Object>> findMembersUngroupedByOrgId(String orgId);

    /**
     * @param queryFilter
     * @return
     */
    public PageList<CmgtDutyTeamMemberDto> pageQuery(QueryFilter<CmgtDutyTeamMember> queryFilter);

    /**
     * 新增
     *
     * @param t
     * @return
     */
    String createInfo(CmgtDutyTeamMember t);

    /**
     * 更新
     *
     * @param t
     * @return
     */
    String updateInfo(CmgtDutyTeamMember t);

    /**
     * 删除
     *
     * @param t
     */
    void deleteInfo(CmgtDutyTeamMember t);


    String create(CmgtDutyTeamMemberDto dto);

    String update(CmgtDutyTeamMemberDto dto);

    boolean delete(List<String> ids);


}
