package com.artfess.manage.safty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * cmgt_safty_training_record_detail
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyTrainingRecordDetail对象", description="安全培训记录人员明细")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyTrainingRecordDetail extends ManageBaseModel<CmgtSaftyTrainingRecordDetail> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 培训记录ID */
    @ApiModelProperty(value = "培训记录ID")
    @TableField("training_id_")
    private String trainingId;

    /** 培训人员 */
    @ApiModelProperty(value = "培训人员")
    @TableField("trainee_")
    private String trainee;

    /** 评分 */
    @ApiModelProperty(value = "评分")
    @TableField("score_")
    private String score;

    /** 培训反馈 */
    @ApiModelProperty(value = "培训反馈")
    @TableField("feedback_")
    private String feedback;

    /** 培训评价 */
    @ApiModelProperty(value = "培训评价")
    @TableField("evaluation_")
    private String evaluation;

    /** 培训总结 */
    @ApiModelProperty(value = "培训总结")
    @TableField("summary_")
    private String summary;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
