package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.dao.CmgtSaftyDangerCheckrecordDao;
import com.artfess.manage.safty.dao.CmgtSaftyDangerUnitDao;
import com.artfess.manage.safty.manager.CmgtSaftyDangerCheckrecordManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyDangerCheckrecordDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyDangerCheckrecordDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyDangerCheckrecord;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.stream.Collectors;

/**
 * 安全隐患排查记录 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Service
public class CmgtSaftyDangerCheckrecordManagerImpl extends BaseManagerImpl<CmgtSaftyDangerCheckrecordDao, CmgtSaftyDangerCheckrecord> implements CmgtSaftyDangerCheckrecordManager {

    @Resource
    private CmgtSaftyDangerCheckrecordDao cmgtSaftyDangerCheckrecordDao;

    @Resource
    private CmgtSaftyDangerCheckrecordDtoMapper cmgtSaftyDangerCheckrecordDtoMapper;

    @Resource
    private CmgtSaftyDangerUnitDao cmgtSaftyDangerUnitDao;

    @Override
    public PageList<CmgtSaftyDangerCheckrecordDto> pageQuery(QueryFilter<CmgtSaftyDangerCheckrecord> queryFilter) {
        PageList<CmgtSaftyDangerCheckrecord> result = query(queryFilter);
        PageList<CmgtSaftyDangerCheckrecordDto> r = new PageList<CmgtSaftyDangerCheckrecordDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyDangerCheckrecordDto t = cmgtSaftyDangerCheckrecordDtoMapper.toDto(e);
                            if (t.getRecipient() != null) {
                                t.setCmgtSaftyDangerUnit(cmgtSaftyDangerUnitDao.selectById(t.getRecipient()));
                            } else {
                                t.setCmgtSaftyDangerUnit(new CmgtSaftyDangerUnit());
                            }
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyDangerCheckrecord t) {
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyDangerCheckrecord t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyDangerCheckrecord t) {
        this.baseMapper.deleteById(t.getId());
    }
}
