package com.artfess.manage.safty.manager.dto;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;



/**
 * cmgt_safty_appraisal
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyAppraisalDto", description="安全目标考核DTO对象")
public class CmgtSaftyAppraisalDto extends ManageBaseModel<CmgtSaftyAppraisalDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 所属部门 */
    @ApiModelProperty(value = "所属部门")
    private String deptId;

    private Object deptIdName;



    /** 所属目标 */
    @ApiModelProperty(value = "所属目标")
    private String targetId;

    private Object targetIdName;



    /** 所属计划 */
    @ApiModelProperty(value = "所属计划")
    private String planTaskId;

    private Object planTaskIdName;



    /** 责任人 */
    @ApiModelProperty(value = "责任人")
    private String userId;

    private Object userIdName;



    /** 任务工作情况 */
    @ApiModelProperty(value = "任务工作情况")
    private String appraisalDetail;




    /** 目标完成值 */
    @ApiModelProperty(value = "目标完成值")
    private String appraisalVal;




    /** 任务完成时间 */
    @ApiModelProperty(value = "任务完成时间")
    private LocalDate taskFinishDate;




    /** 考核结论 */
    @ApiModelProperty(value = "考核结论")
    private String result;




    /** 依据 */
    @ApiModelProperty(value = "依据")
    private String according;




    /** 考评人 */
    @ApiModelProperty(value = "考评人")
    private String appraisalUser;

    private Object appraisalUserName;



    /** 考核日期 */
    @ApiModelProperty(value = "考核日期")
    private LocalDate appraisalDate;




    /** 附件 */
    @ApiModelProperty(value = "附件")
    private String attachment;


    public void setAttachmentFileList(JSONArray o) {
        if (o != null) {
            this.attachment= JSONUtil.parse(o).toStringPretty();
        } else {
            this.attachment= null;
        }
    }

    public JSONArray getAttachmentFileList() {
        if (this.attachment!= null) {
            return JSONUtil.parseArray(this.attachment);
        } else {
            return JSONUtil.createArray();
        }
    }


    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;





    private String createByName;

}
