package com.artfess.manage.duty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberGpsinfoDao;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberGpsinfoManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberGpsinfoDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyTeamMemberGpsinfoDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyTeamMemberGpsinfo;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 队员GPS信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-09-24
 */
@Service
public class CmgtDutyTeamMemberGpsinfoManagerImpl extends BaseManagerImpl<CmgtDutyTeamMemberGpsinfoDao, CmgtDutyTeamMemberGpsinfo> implements CmgtDutyTeamMemberGpsinfoManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtDutyTeamMemberGpsinfoDao cmgtDutyTeamMemberGpsinfoDao;

    @Resource
    private CmgtDutyTeamMemberGpsinfoDtoMapper cmgtDutyTeamMemberGpsinfoDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtDutyTeamMemberGpsinfoDto> pageQuery(QueryFilter<CmgtDutyTeamMemberGpsinfo> queryFilter) {
        PageList<CmgtDutyTeamMemberGpsinfo> result = query(queryFilter);
        PageList<CmgtDutyTeamMemberGpsinfoDto> r = new PageList<CmgtDutyTeamMemberGpsinfoDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyTeamMemberGpsinfoDto t = cmgtDutyTeamMemberGpsinfoDtoMapper.toDto(e);
                                    t.setTeamMemberIdName(manageCommonService.getfindSelectOptionsLabel("cmgtDutySelectOptions.getCmgtDutyTeamMemeber","value","label",t.getTeamMemberId()));


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyTeamMemberGpsinfo t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyTeamMemberGpsinfo t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyTeamMemberGpsinfo t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtDutyTeamMemberGpsinfoDto dto) {
        CmgtDutyTeamMemberGpsinfo t = cmgtDutyTeamMemberGpsinfoDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtDutyTeamMemberGpsinfoDto dto) {
        CmgtDutyTeamMemberGpsinfo t = cmgtDutyTeamMemberGpsinfoDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
