/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialFlowLogManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import com.artfess.manage.material.vo.RecipientsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u8d44\u7ba1\u7406-\u91c7\u8d2d\u9886\u7528\u7533\u8bf7\u5355"})
@RequestMapping(value={"/manager/material/purchasing/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialPurchasingController
extends BaseController<CmgtMaterialPurchasingManager, CmgtMaterialPurchasing> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialPurchasingController.class);
    @Autowired
    private CmgtMaterialPurchasingDetailManager materialPurchasingDetailManager;
    @Autowired
    private CmgtMaterialPurchasingManager cmgtMaterialPurchasingManager;
    @Autowired
    private CmgtMaterialFlowLogManager flowLogManager;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0\u7269\u8d44\u9886\u7528\u6216\u8005\u91c7\u8d2d\u7533\u8bf7\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtMaterialPurchasing t) {
        this.cmgtMaterialPurchasingManager.createInfo(t);
        return new CommonResult();
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u7269\u8d44\u9886\u7528\u6216\u8005\u91c7\u8d2d\u7533\u8bf7")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtMaterialPurchasing t) {
        this.cmgtMaterialPurchasingManager.updateInfo(t);
        return new CommonResult();
    }

    @PostMapping(value={"/getDetailList"})
    @ApiOperation(value="\u83b7\u53d6\u7533\u8bf7\u5355\u4e0b\u6240\u6709\u7269\u8d44\u660e\u7ec6")
    public CommonResult<String> getDetailList(@ApiParam(name="pid", value="\u7533\u8bf7\u5355id") @RequestBody String pid) {
        List<CmgtMaterialPurchasingDetail> list = this.materialPurchasingDetailManager.findAllByPurchasingId(pid);
        return CommonResult.success(list, null);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = true;
        for (String id : ids) {
            this.materialPurchasingDetailManager.deleteByMaterialInfoId(id);
            result = this.cmgtMaterialPurchasingManager.deleteById(id);
        }
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/findByIds"})
    @ApiOperation(value="\u6839\u636e\u9009\u4e2d\u7684\u91c7\u8d2d\u7533\u8bf7\u5355ids\u83b7\u53d6\u5408\u5e76\u540e\u7684\u7269\u8d44\u4fe1\u606f")
    public CommonResult<String> findByIds(String ... ids) {
        Assert.notEmpty((Object[])ids, (String)"\u8bf7\u9009\u62e9\u8981\u5408\u5e76\u7684\u7533\u8bf7\u5355");
        List<CmgtMaterialPurchasingDetail> list = ((CmgtMaterialPurchasingManager)this.baseService).detailList(Arrays.asList(ids));
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="\u7533\u8bf7\u5355\u786e\u8ba4")
    public CommonResult<String> updateStatus(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CmgtMaterialPurchasing t) {
        boolean result = ((CmgtMaterialPurchasingManager)this.baseService).updateStatus(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u786e\u8ba4\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u91c7\u8d2d\u7533\u8bf7\u5355\u5217\u8868")
    public PageList<CmgtMaterialPurchasing> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtMaterialPurchasing> queryFilter) {
        queryFilter.addFilter("applyType", (Object)"1", QueryOP.EQUAL);
        return ((CmgtMaterialPurchasingManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/count"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u6708\u7269\u8d44\u91c7\u8d2d\u7533\u8bf7\u5355\u6570\u91cf")
    public CommonResult count(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtMaterialPurchasing> queryFilter) {
        queryFilter.addFilter("applyType", (Object)"1", QueryOP.EQUAL);
        queryFilter.addFilter("APPLICATION_DATE_", (Object)LocalDate.now(), QueryOP.EQUAL);
        queryFilter.getPageBean().setPageSize(-1);
        PageList query = ((CmgtMaterialPurchasingManager)this.baseService).query(queryFilter);
        return CommonResult.success((Object)query.getRows().size(), null);
    }

    @PostMapping(value={"/recipientsQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u9886\u7528\u7533\u8bf7\u5355\u5217\u8868")
    public PageList<CmgtMaterialPurchasing> recipientsQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtMaterialPurchasing> queryFilter) {
        queryFilter.addFilter("applyType", (Object)"2", QueryOP.EQUAL);
        return ((CmgtMaterialPurchasingManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/recipientsPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u9886\u7528\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    public PageList<CmgtMaterialPurchasing> recipientsPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtMaterialPurchasing> queryFilter) {
        queryFilter.addFilter("applyType", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)"1", QueryOP.NOT_EQUAL);
        PageList query = ((CmgtMaterialPurchasingManager)this.baseService).query(queryFilter);
        query.getRows().forEach(cmgtMaterialPurchasing -> {
            if ("2".equals(cmgtMaterialPurchasing.getStatus())) {
                cmgtMaterialPurchasing.setStatus("\u672a\u9886\u7528");
            }
            if ("3".equals(cmgtMaterialPurchasing.getStatus())) {
                cmgtMaterialPurchasing.setStatus("\u5df2\u9886\u7528");
            }
        });
        return ((CmgtMaterialPurchasingManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/recipients"})
    @ApiOperation(value="\u9886\u7528\u7269\u8d44")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) RecipientsVo t) {
        boolean save = this.flowLogManager.recipients(t);
        if (!save) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/recipientsMaterialList"})
    @ApiOperation(value="\u6839\u636e\u9009\u4e2d\u7684\u9886\u7528\u7533\u8bf7\u5355ids\u83b7\u53d6\u9886\u7528\u7269\u8d44\u4fe1\u606f")
    public CommonResult<String> recipientsMaterialList(String ... ids) {
        Assert.notEmpty((Object[])ids, (String)"\u8bf7\u9009\u62e9\u8981\u9886\u7528\u7684\u7533\u8bf7\u5355");
        List<CmgtMaterialPurchasingDetail> list = ((CmgtMaterialPurchasingManager)this.baseService).recipientsMaterialList(Arrays.asList(ids));
        return CommonResult.success(list, null);
    }
}

