/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manager/material/purchasing/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialPurchasingController
extends BaseController<CmgtMaterialPurchasingManager, CmgtMaterialPurchasing> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialPurchasingController.class);
    @Autowired
    private CmgtMaterialPurchasingDetailManager materialPurchasingDetailManager;
    @Autowired
    private CmgtMaterialPurchasingManager cmgtMaterialPurchasingManager;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtMaterialPurchasing t) {
        boolean result = ((CmgtMaterialPurchasingManager)this.baseService).save((Object)t);
        ArrayList dlist = new ArrayList();
        t.getDetailList().forEach(d -> {
            d.setPurchasingId(t.getId());
            dlist.add(d);
        });
        this.materialPurchasingDetailManager.saveBatch(dlist);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtMaterialPurchasing t) {
        this.materialPurchasingDetailManager.deleteByMaterialInfoId(t.getId());
        ArrayList dlist = new ArrayList();
        t.getDetailList().forEach(d -> {
            d.setPurchasingId(t.getId());
            d.setId(null);
            dlist.add(d);
        });
        this.materialPurchasingDetailManager.saveBatch(t.getDetailList());
        boolean result = ((CmgtMaterialPurchasingManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getDetailList"})
    @ApiOperation(value="\u83b7\u53d6\u7533\u8bf7\u5355\u4e0b\u6240\u6709\u7269\u8d44\u660e\u7ec6")
    public CommonResult<String> getDetailList(@RequestBody String pid) {
        List<CmgtMaterialPurchasingDetail> list = this.materialPurchasingDetailManager.findAllByPurchasingId(pid);
        return CommonResult.success(list, null);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = true;
        for (String id : ids) {
            this.materialPurchasingDetailManager.deleteByMaterialInfoId(id);
            result = this.cmgtMaterialPurchasingManager.deleteById(id);
        }
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

