package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.vo.HomeRealTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author 黎沐华
 * @date 2022/9/21 10:18
 */
@Slf4j
@RestController
@Api(tags = "首页")
@RequestMapping("/homepage/v1/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class HomePageController {

    @Autowired
    private DeviceInfoManager deviceManager;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;

    @PostMapping("/deviceStatistics")
    @ApiOperation("设备统计")
    public CommonResult<List<StatisticsVo>> deviceStatistics() {
        log.info("设备统计请求开始......");
        List<StatisticsVo> data = deviceManager.homeStatistics();
        log.info("设备统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("currentStatusAnalyze")
    @ApiOperation("当前设备状态分析")
    public CommonResult<List<StatisticsVo>> currentStatusAnalyze() {
        log.info("当前设备状态分析请求开始......");
        List<StatisticsVo> data = deviceManager.currentStatusAnalyze();
        log.info("当前设备状态分析响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/monthlyAnalyze")
    @ApiOperation("近一月状态分析")
    public CommonResult<List<StatisticsVo>> monthlyAnalyze(@RequestParam @ApiParam(name = "code", value = "产品分类编码") String code) {
        log.info("近一月状态分析请求开始......");
        List<StatisticsVo> data = deviceManager.monthlyAnalyze(code);
        log.info("近一月状态分析响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/realTimeData")
    @ApiOperation("实时数据")
    public CommonResult<List<HomeRealTimeVo>> realTimeData(@RequestParam @ApiParam(name = "code", value = "ProductTypeEnum 的code") String code) {
        log.info("实时数据请求参数:{}", code);
        List<HomeRealTimeVo> data = deviceManager.homeRealTime(code);
        log.info("实时数据响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

}
