package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 操控升降柱请求vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-04
 */
@Data
@ApiModel(value="操控升降柱请求vo")
public class ActGroupVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "目标升降柱的控制器 id。 （设备Id,必传）")
    private String controller_id;

    @ApiModelProperty(value = "动作标识，（01-上升，10-下降，20-锁定，21-解锁）（必传）")
    private String action;

    @ApiModelProperty(value = "操控类型")
    private String privilege_level;

    @ApiModelProperty(value = "操控权限等级")
    private String operate_type;

    @ApiModelProperty(value = "操控者名称（系统登录用户名）")
    private String operator_name;

    @ApiModelProperty(value = "设备名称")
    private String deviceName;

    @ApiModelProperty(value = "设备唯一标识")
    private String deviceCode;

}
