package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 绩效考核-考核项目信息（DEVICE_APPRAISE_ITEMS）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Data
@TableName("device_appraise_items")
@ApiModel(value="DeviceAppraiseItems对象", description="绩效考核-考核项目信息（DEVICE_APPRAISE_ITEMS）")
public class AppraiseItems extends AutoFillModel<AppraiseItems> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定考核项id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写考核信息ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核信息ID")
    @TableField("BASE_ID_")
    private String baseId;

    @NotBlank(message = "请填写考核项内容",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核项内容")
    @TableField("item_")
    private String item;

    @NotNull(message = "请填写考核项权重值",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核项权重值（1以内的2位小数）")
    @TableField("item_val_")
    private BigDecimal itemVal;

    @ApiModelProperty(value = "考核项排序")
    @TableField("ITEM_SN_")
    private Integer itemSn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

}
