package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.DeviceBaseSpareDao;
import com.artfess.device.base.manager.DeviceBaseSpareManager;
import com.artfess.device.base.model.DeviceBaseSpare;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 对备品件进行管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseSpareManagerImpl extends BaseManagerImpl<DeviceBaseSpareDao, DeviceBaseSpare> implements DeviceBaseSpareManager {

    @Override
    public PageList<DeviceBaseSpare> findByPage(QueryFilter<DeviceBaseSpare> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceBaseSpare> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<DeviceBaseSpare>(result);
    }

    @Override
    public List<DeviceBaseSpare> findByHouseIds(List<String> houseIds) {
        QueryWrapper<DeviceBaseSpare> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("WAREHOUSE_ID_", houseIds);
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        return baseMapper.selectList(queryWrapper);
    }
}
