package com.artfess.device.monitor.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 实时监控-水位监控（DEVICE_DATA_WATER）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
@Data
@TableName("device_data_water")
@ApiModel(value="DeviceDataWater对象", description="实时监控-水位监控（DEVICE_DATA_WATER）")
public class DeviceDataWater extends BaseModel<DeviceDataWater> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据采集时间")
    @TableField("coll_time_")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "设备唯一标识")
    @TableField("device_code_")
    private String deviceCode;

    @ApiModelProperty(value = "原始采集数据")
    @TableField("src_data_")
    private String srcData;

    @ApiModelProperty(value = "原始采集数据")
    @TableField("data_type_")
    private String dataType;

    @ApiModelProperty(value = "水位高度")
    @TableField("sdata_")
    private Double sdata;

    @ApiModelProperty(value = "设备电压（单位：V）")
    @TableField("voltage_")
    private Double voltage;

    @ApiModelProperty(value = "报警ID")
    @TableField("warn_id_")
    private String warnId;

    @ApiModelProperty(value = "入库时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;

}
