package com.artfess.device.monitor.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.vo.ActGroupVo;
import com.artfess.device.monitor.manager.DeviceDataBarricadeManager;
import com.artfess.device.monitor.model.DeviceDataBarricade;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 实时监控-路障操作数据（DEVICE_DATA_BARRICADE） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
@Slf4j
@RestController
@Api(tags = "设施数据-路障操作数据")
@RequestMapping("/data/barricade/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceDataBarricadeController extends BaseController<DeviceDataBarricadeManager, DeviceDataBarricade> {

    @PostMapping("/batchAct")
    @ApiOperation("批量操作路障设备")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "批量操作路障设备")
    public CommonResult<String> batchAct(@ApiParam(name = "model", value = "批量操作路障设备") @RequestBody List<ActGroupVo> entity) {
        log.info("批量操作路障设备:{}", JSON.toJSONString(entity));
        String result = baseService.batchAct(entity);
        return CommonResult.success(result, null);
    }

    @PostMapping("/lockAct")
    @ApiOperation(value = "锁定&解锁路障设备", notes = "兼容批量")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "解锁路障设备")
    public CommonResult<String> lockAct(@ApiParam(name = "model", value = "解锁路障设备") @RequestBody List<ActGroupVo> entity) {
        log.info("批量操作路障设备:{}", JSON.toJSONString(entity));
        String result = baseService.lockAct(entity);
        return CommonResult.success(result, null);
    }

}
