package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author 黎沐华
 * @date 2022/9/21 14:40
 */
@Data
public class HomeRealTimeVo {

    @ApiModelProperty(value = "设备标识")
    private String code;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "安装详细地址")
    private String address;

    @ApiModelProperty(value = "数据采集时间")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "X 轴角度 (单位：°度)")
    private BigDecimal angleX;

    @ApiModelProperty(value = "Y 轴角度 (单位：°度)")
    private BigDecimal angleY;

    @ApiModelProperty(value = "Z 轴角度 (单位：°度)")
    private BigDecimal angleZ;

    @ApiModelProperty(value = "电池电量（单位：%）")
    private BigDecimal batteryValue;

    @ApiModelProperty(value = "设备电压（单位：V）")
    private BigDecimal batteryVoltage;

    @ApiModelProperty(value = "水位高度 / 甲烷浓度")
    private Double sdata;

    @ApiModelProperty(value = "设备电压（单位：V）")
    private Double voltage;

    @ApiModelProperty(value = "升降柱最近的一次动作【字典】（01-上升，10-下降）")
    private String lastAction;

    @ApiModelProperty(value = "升降柱位置状态【字典】（00-底部，FF-顶部，55-中间）")
    private String status;

    @ApiModelProperty(value = "报警状态【字典】(0001-上限位报警，0002-下限位报警，0003-补压报警，空字符串-没有报警)")
    private String alert;

}
