package com.artfess.device.base.vo;

import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 单位人员树vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-18
 */
@Data
@ApiModel(value="设备分组关联vo")
public class CompanyAndUserVo implements Tree {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "数据类型 1 单位 2人员")
    private Integer type;

    @ApiModelProperty(value = "上级id")
    private String parentId;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<CompanyAndUserVo> children = Lists.newArrayList();

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {

    }
}
