package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 收藏视频目录或者监控点
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-02-16
 */
@Data
@ApiModel(value="CollectVo对象")
public class CollectVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "收藏夹名称")
    private String name;

    @ApiModelProperty(value = "监控点编码")
    private String resCode;

    @ApiModelProperty(value = "类型1文件夹 2监控点")
    private String type;

    @ApiModelProperty(value = "父级id（文件夹）")
    private String parentId;

    @ApiModelProperty(value = "区域信息编码，获取监控点分页才使用")
    private String zoneCode;


}
