package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对单位人员信息进行管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Data
@ApiModel(value="DeviceBaseUser对象", description="对单位人员信息进行管理")
@FieldRepeat(fields = {"code","name"},message = "人员名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DeviceBaseUser extends AutoFillModel<DeviceBaseUser> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定单位id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择所属单位",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "所属单位")
    @TableField("COMPANY_ID_")
    private String companyId;

    @NotBlank(message = "请填写人员编码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "人员编码")
    @TableField("CODE_")
    private String code;

    @NotBlank(message = "请填写人员名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "人员名称")
    @TableField("NAME_")
    private String name;

    @NotBlank(message = "请选择人员类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "人员类型(1:管理人员 、2:建设人员、3:运维人员)")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "联系方式")
    @TableField("TEL_")
    private String tel;

    @ApiModelProperty(value = "联系人")
    @TableField("MOBILE_")
    private String mobile;

    @ApiModelProperty(value = "单位地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "扩展信息填充内容")
    @TableField(exist = false)
    private List<DeviceBaseParamsValue> paramsValueList;

    @ApiModelProperty(value = "单位名称")
    @TableField(exist = false)
    private String companyName;

}
