package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceBaseCompany;
import com.artfess.device.base.vo.CompanyAndUserVo;

import java.util.List;

/**
 * 对单位（管理单位、运维单位、设备厂商、供应商）信息进行管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
public interface DeviceBaseCompanyManager extends BaseManager<DeviceBaseCompany> {

    /**
     * 根据条件查询所有单位列表
     * @param company
     * @return
     */
    List<DeviceBaseCompany> findAll(DeviceBaseCompany company);

    /**
     * 获取单位人员二级下拉
     * @param company
     * @return
     */
    List<CompanyAndUserVo> getCompanyAndUser(DeviceBaseCompany company);
}
