package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceBaseContractManager;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.model.DeviceBaseContract;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对合同信息进行管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Slf4j
@RestController
@Api(tags = "设施设备-合同管理")
@RequestMapping("/device/base/contract/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceBaseContractController extends BaseController<DeviceBaseContractManager, DeviceBaseContract> {

    @Autowired
    private DeviceBaseParamsConfManager deviceBaseParamsConfManager;

    @PostMapping("/saveContract")
    @ApiOperation("添加合同信息")
    public CommonResult<String> saveContract(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceBaseContract t) {
        boolean result = baseService.saveContract(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult<>(t.getId());
    }


    @GetMapping("/findById/{id}")
    @ApiOperation("根据id查询合同")
    public DeviceBaseContract findById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.findById(id);
    }

    @PostMapping("/updateContract")
    @ApiOperation("更新合同信息")
    public CommonResult<String> updateContract(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceBaseContract t) {
        boolean result = baseService.updateContract(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult<>();
    }

    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<DeviceBaseContract> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<DeviceBaseContract> queryFilter) {
        return baseService.findByPage(queryFilter);
    }



}
