/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.manage.safty.dao.CmgtSaftyCheckDao;
import com.artfess.manage.safty.manager.CmgtSaftyCheckItemManager;
import com.artfess.manage.safty.manager.CmgtSaftyCheckManager;
import com.artfess.manage.safty.manager.CmgtSaftyTargetManager;
import com.artfess.manage.safty.model.CmgtSaftyCheck;
import com.artfess.manage.safty.model.CmgtSaftyCheckItem;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="cmgtSaftyCheckService")
public class CmgtSaftyCheckManagerImpl
extends BaseManagerImpl<CmgtSaftyCheckDao, CmgtSaftyCheck>
implements CmgtSaftyCheckManager {
    @Resource
    private CmgtSaftyCheckItemManager itemManager;
    @Resource
    private CmgtSaftyTargetManager targetManager;

    public PageList<CmgtSaftyCheck> query(QueryFilter<CmgtSaftyCheck> queryFilter) {
        List details = this.itemManager.list();
        PageList result = super.query(queryFilter);
        result.getRows().forEach(r -> r.getDetail().addAll(details.stream().filter(d -> r.getId().equals(d.getInfoId())).collect(Collectors.toList())));
        return result;
    }

    public boolean save(CmgtSaftyCheck entity) {
        this.calScore(entity);
        boolean result = super.save((Object)entity);
        if (BeanUtils.isNotEmpty(entity.getDetail())) {
            entity.getDetail().forEach(d -> d.setInfoId(entity.getId()));
            this.itemManager.saveBatch(entity.getDetail());
        }
        return result;
    }

    public boolean updateById(CmgtSaftyCheck entity) {
        this.calScore(entity);
        return super.updateById((Object)entity);
    }

    private void calScore(CmgtSaftyCheck entity) {
        CmgtSaftyTarget target = (CmgtSaftyTarget)((Object)this.targetManager.getById((Serializable)((Object)entity.getTargetId())));
        BigDecimal checkScore = new BigDecimal(0);
        if (BeanUtils.isNotEmpty(entity.getDetail()) && BeanUtils.isNotEmpty(target.getDetail())) {
            entity.getDetail().forEach(ed -> target.getDetail().forEach(td -> {
                if (ed.getItemId().equals(td.getId())) {
                    BigDecimal itemResult = new BigDecimal(null == ed.getItemScore() ? 0 : ed.getItemScore()).multiply(new BigDecimal(null == td.getCheckWeight() ? 0 : td.getCheckWeight()));
                    ed.setItemResult(itemResult);
                    checkScore.add(itemResult);
                }
            }));
        }
        entity.setCheckScore(checkScore);
    }

    public void removeByIds(String ... ids) {
        List detailIds = this.itemManager.list((Wrapper)new QueryWrapper().in((Object)"target_year_", (Object[])ids)).stream().map(CmgtSaftyCheckItem::getId).collect(Collectors.toList());
        this.itemManager.removeByIds(detailIds);
        super.removeByIds(ids);
    }
}

