import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全培训记录人员明细
  addCmgtSaftyTrainingRecordDetail(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainingRecordDetail/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全培训记录人员明细
  editCmgtSaftyTrainingRecordDetail(data, cb) {
    req.put(portal + `/manager/cmgtSaftyTrainingRecordDetail/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全培训记录人员明细
  loadCmgtSaftyTrainingRecordDetail(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainingRecordDetail/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全培训记录人员明细
  deleteCmgtSaftyTrainingRecordDetail(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyTrainingRecordDetail/delete`, data).then(res => {
      cb(res.data)
    })
  },
}
