import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增排班信息
  addCmgtDutyWorkarrange(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/add`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改排班信息
  editCmgtDutyWorkarrange(data, cb) {
    req.put(portal + `/manager/cmgtDutyWorkarrange/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询排班信息
  loadCmgtDutyWorkarrange(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除排班信息
  deleteCmgtDutyWorkarrange(data, cb) {
    req.remove(portal + `/manager/cmgtDutyWorkarrange/?ids=` + data).then(res => {
      cb(res.data)
    })
  },
  // 获取小组信息
  findTeam(orgId, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/team`, orgId).then(res => {
      cb(res.data)
    })
  },
  // 获取小组信息
  findTeamMember(orgId, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/teamMember`, orgId).then(res => {
      cb(res.data)
    })
  },

  // 获取班种信息
  findClass(orgId, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/class`, orgId).then(res => {
      cb(res.data)
    })
  },
  // 获取人员信息
  findMembersByteamId(teamId, cb) {
    req.get(portal + `/manager/cmgtDutyWorkarrange/query/members?teamId=` + teamId).then(res => {
      cb(res.data)
    })
  },
  // 获取人员信息
  findMembersBy(teamId, orgId, cb) {
    req.get(portal + `/manager/cmgtDutyWorkarrange/query/members?orgId=` + orgId + `&teamId=` + teamId).then(res => {
      cb(res.data)
    })
  },
  // 获取人员信息
  findMembersByOrg(orgId, cb) {
    req.get(portal + `/manager/cmgtDutyWorkarrange/query/members?orgId=` + orgId).then(res => {
      cb(res.data)
    })
  },
  // 获取部门排班表信息
  findAllOrgArrange(cb) {
    req.post(portal + '/manager/cmgtDutyOrgWorkarrange/findAll/').then(res => {
      cb(res)
    })
  },
  findMonthArrangeInfo(data, cb) { // 获取每月排班信息
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/findMonthArrangeInfo`, data).then(res => {
      cb(res.data)
    })
  },
  findTeamMemberArrangeing(data, cb) { // 获取每月排班信息
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/findTeamMemberArrangeing`, data).then(res => {
      cb(res.data)
    })
  },

  fastWorkArrange(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/fastWorkArrange`, data).then(res => {
      cb(res)
    })
  },
  // 导出
  exportArrange(date) {
    req.downloadPostCopy(portal + `/manager/cmgtDutyWorkarrange/export`, date).then(response => {
      const blob = new Blob([response.data], {
        type: 'application/vnd.ms-excel'
      })
      const fileName = Date.parse(new Date()) + '.xls'
      if (window.navigator.msSaveOrOpenBlob) {
        navigator.msSaveBlob(blob, fileName)
      } else {
        var link = document.createElement('a')
        link.href = window.URL.createObjectURL(blob)
        link.download = fileName
        link.click()
        // 释放内存
        window.URL.revokeObjectURL(link.href)
      }
    })
  },
  // 按人导出数据
  exportMemberArrange(date) {
    req.downloadPostCopy(portal + `/manager/cmgtDutyWorkarrange/exportmember`, date).then(response => {
      const blob = new Blob([response.data], {
        type: 'application/vnd.ms-excel'
      })
      const fileName = Date.parse(new Date()) + '.xls'
      if (window.navigator.msSaveOrOpenBlob) {
        navigator.msSaveBlob(blob, fileName)
      } else {
        var link = document.createElement('a')
        link.href = window.URL.createObjectURL(blob)
        link.download = fileName
        link.click()
        // 释放内存
        window.URL.revokeObjectURL(link.href)
      }
    })
  },

  // 查询当前在勤人员
  findCurrentStaffOnDuty(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/onDudyMember`, data).then(res => {
      cb(res.data)
    })
  },

  // 查询当前用户所数组织
  getUserOrganization(id, cb) {
    req.get(portal + `/api/org/v1/orgs/getOrgListByUserId?userId=` + id).then(res => {
      cb(res.data)
    })
  },

  // 查询小组当月人员排班表
  findTeamMemberList(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/findTeamMemberList`, data).then(res => {
      cb(res.data)
    })
  },

  // 查询小组当月所有班次下人员排班表
  findTeamWorkClass(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/query/findTeamWorkClass`, data).then(res => {
      cb(res.data)
    })
  },

  // 小组当月人员排班数据导出
  workClassExportList(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/teamMemberList/export`, data, 'blob').then(res => {
      cb(res.data)
    })
  },

  // 小组当月所有班次下人员排班数据导出
  workClassExportAll(data, cb) {
    req.post(portal + `/manager/cmgtDutyWorkarrange/teamWorkClass/export`, data, 'blob').then(res => {
      cb(res.data)
    })
  },

  // 查询小组当月所有班次下人员排班表
  findPersonArrange(data) {
    let { date, phone } = data
    return req.post(portal + `/manager/cmgtDutyWorkarrange/query/findPersonArrange?date=${date}&phone=${phone}`)
  }

}
