import req from '@/request.js'

const portal = window.context.portal
export default {
  //获取列表数据-安全隐患检查(节假日cmgtSafeCheckHolidays)
  CmgTSaftyHazardCheckList(data, cb) {
    req.post(portal + `/cmgtSafeCheckHolidays/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增接口
  addAction(data, cb) {
    req.post(portal + `/cmgtSafeCheckHolidays/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  //修改
  editCmgtSaftyTarget(data, cb) {
    req.put(portal + `/cmgtSafeCheckHolidays/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除
  deleteCmgtSaftyHC(data, cb) {
    req.remove(portal + `/cmgtSafeCheckDaily/v1/delete/ids`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/cmgtSafeCheckHolidays/v1/` + id).then(res => {
      cb(res.data)
    })
  }
}
