import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增物资申请信息
  addPurchasing(data, cb) {
    req.post(portal + `/manager/material/purchasing/add`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改物资申请信息
  editPurchasing(data, cb) {
    req.put(portal + `/manager/material/purchasing/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询物资申请信息
  loadPurchasing(data, cb) {
    req.post(portal + `/manager/material/purchasing/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除物资申请信息
  deletePurchasing(data, cb) {
    req.remove(portal + `/manager/material/purchasing/delete`, data).then(res => {
      cb(res.data)
    })
  },
  loadMaterialDetail(data, cb){
	 req.post(portal + `/manager/material/purchasing/getDetailList`, data).then(res => {
	   cb(res.data)
	 })
  }
}