import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检台账表格数据
export function statisticsCaseHandleSituation(query) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/statisticsCaseHandleSituation?${qs.stringify(query)}`)
      .then(response => {
        resolve(response?.data[0] || {})
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 案件类型排名统计
export function statisticsHandleStatus(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/statisticsHandleStatus?${qs.stringify(query)}`)
      .then(res => resolve(res?.data?.[0] || {}))
      .catch(err => reject(err))
  })
}

// 统计部门办理状况
export function statisticsDeptHandleStatus(query) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/statisticsDeptHandleStatus?${qs.stringify(query)}`)
      .then(response => {
        resolve(response?.data || [])
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 案件来源排名统计
export function queryCaseSourceSortStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryCaseSourceSortStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 案件类型排名统计
export function queryCaseTypeSortStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryCaseTypeSortStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}










