import menuData from '@/api/mock/menu-data.js'
import store from '@/store'

export default {
  getMenus() {
    return menuData.getMenus()
  },
  getMenuByAlias(alias, cb) {
    let r = null
    let _menu = store.state.menu.frontMenus
    if (!_menu || _menu.length == 0) {
      let storageMenus = sessionStorage.getItem('currentFrontMenus')
      if (storageMenus) {
        _menu = JSON.parse(storageMenus)
      }
    }
    _menu.forEach((x) => {
      if (r == null) {
        r = this.getMenuData(x, alias, null)
      }
    })
    // console.log(r, 'r')
    cb(r)
  },
  getMenuData(data, alias, parent) {
    let result
    if (data.alias == alias) {
      result = data
      result.parent = parent
    } else if (data.children.length) {
      data.children.forEach(item => {
        if (!result) {
          result = this.getMenuData(item, alias, data)
        }
      })
    }
    return result
  },
  getFrontMenuByAlias(alias, cb) {
    let r = null
    let _menu = store.state.menu.frontMenus
    if (!_menu || _menu.length == 0) {
      let storageMenus = sessionStorage.getItem('currentFrontMenus')
      if (storageMenus) {
        _menu = JSON.parse(storageMenus)
      }
    }
    _menu.forEach(function(x) {
      if (x.children) {
        if (!r || r.length == 0) {
          r = x.children.filter(m => m.alias == alias)
          if (r && r.length == 1) {
            r[0].parent = x
          }
        }
      }
    })
    cb(r && r[0])
  }
}
