import req from '@/request.js'
import qs from 'qs'
const portal = window.context.portal
export default {
  // 新增车辆信息
  addVehicle(data, cb) {
    req.post(portal + `/manager/duty/vehicle/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改车辆信息
  editVehicle(data, cb) {
    req.put(portal + `/manager/duty/vehicle/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询车辆信息
  loadVehicle(data, cb) {
    req.post(portal + `/manager/duty/vehicle/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除车辆信息
  deleteVehicle(data, cb) {
    req.remove(portal + `/manager/duty/vehicle/`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询车辆轨迹经纬度
  getVehicleLat(data, cb) {
    req.get(portal + `/manager/cmgtDutyVehicleGpsinfo/queryVehicleTrack/?` + data).then(res => {
      cb(res.data)
    })
  },
}