import req from '@/request.js'
const portal = window.context.portal
export default {
  // 分页查询
  queryData(data, cb) {
    req.post(portal + `/case/info/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 更新实体
  entityUpdate(data, cb) {
    req.put(portal + `/case/info/`, data).then(res => {
      cb(res.data)
    })
  },
  //通过id获取详情
  detailData(id, cb) {
    req.get(portal + `/case/info/details?id=` + id).then(res => {
      cb(res.data)
    })
  },
  // 申请立案
  applyFill(data, cb) {
    req.post(portal + `/case/approval/`, data).then(res => {
      cb(res.data)
    })
  },
  //调查取证添加
  addSurvey(data, cb) {
    req.post(portal + `/case/check/`, data).then(res => {
      cb(res.data)
    })
  },
  // 调查取证更新
  updateSurvey(data, cb) {
    req.put(portal + `/case/check/`, data).then(res => {
      cb(res.data)
    })
  },
  //发起审批
  examineSurvey(data, cb) {
    req.post(portal + `/case/approval/`, data).then(res => {
      cb(res.data)
    })
  },
  //通过案件id查询取证详情
  caseIdDetais(id, cb) {
    req.get(portal + `/case/check/findByCaseId/` + id).then(res => {
      cb(res.data)
    })
  },
  //案件处罚添加
  addPenalize(data, cb) {
    req.post(portal + `/case/punish/`, data).then(res => {
      cb(res.data)
    })
  },
  // 案件处罚更新
  updatePenalize(data, cb) {
    req.put(portal + `/case/punish/`, data).then(res => {
      cb(res.data)
    })
  },
  //通过案件id查询案件处罚详情
  caseIdPenalizeDetais(id, cb) {
    req.get(portal + `/case/punish/findByCaseId/` + id).then(res => {
      cb(res.data)
    })
  },
  //案件结案添加
  addClose(data, cb) {
    req.post(portal + `/case/close/`, data).then(res => {
      cb(res.data)
    })
  },
  //案件结案更新
  updateClose(data, cb) {
    req.put(portal + `/case/close/`, data).then(res => {
      cb(res.data)
    })
  },
  //通过案件id查询案件结案详情
  caseIdCloseDetais(id, cb) {
    req.get(portal + `/case/close/findByCaseId/` + id).then(res => {
      cb(res.data)
    })
  }
}
