export default [
  {
    path: '/MobileHome',
    name: 'MobileHome',
    props: true,
    component: () => import('@/views/Mobile/MobileHome.vue'),
    children: [
      /* 设备列表 */
      {
        path: 'MobileDeviceNav',
        name: 'MobileDeviceNav',
        component: () =>
          import('@/views/Mobile/Device/MobileDeviceNav/index.vue'),
        meta: {
          keepAlive: true
        }
      },
      /* 设备列表 */
      {
        path: 'MobileEmpty',
        name: 'MobileEmpty',
        component: () => import('@/views/Mobile/Device/MobileEmpty.vue')
      },
      /* 我的 */
      {
        path: 'MobileMine',
        name: 'MobileMine',
        component: () => import('@/views/Mobile/MobileMine.vue')
      },
      /* 综管 */
      {
        path: 'MobileManageNav',
        name: 'MobileManageNav',
        component: () => import('@/views/Mobile/Manage/MobileManageNav.vue')
      }
    ],
    meta: {
      single: true,
      anonymous: true
    }
  },
  // 设备
  {
    path: '/MobileDeviceHome',
    name: 'MobileDeviceHome',
    props: true,
    component: () => import('@/views/Mobile/Device/MobileDeviceHome.vue'),
    children: [
      /* 设备管理 */
      {
        path: 'MobileDevice',
        name: 'MobileDevice',
        component: () => import('@/views/Mobile/Device/MobileDevice.vue')
      },
      /* 实时监测 */
      {
        path: 'RealDevice',
        name: 'RealDevice',
        component: () => import('@/views/Mobile/Device/RealDevice.vue')
      },
      /* 告警信息 */
      {
        path: 'AlarmDevice',
        name: 'AlarmDevice',
        component: () => import('@/views/Mobile/Device/AlarmDevice.vue')
      },
      /* 设备详情 */
      {
        path: 'DeviceDetail',
        name: 'DeviceDetail',
        component: () => import('@/views/Mobile/Device/DeviceDetail.vue')
      },
      /* 实时数据 */
      {
        path: 'RealtimeData',
        name: 'RealtimeData',
        component: () => import('@/views/Mobile/Device/RealtimeData.vue')
      },
      /* 告警数据 */
      {
        path: 'AlarmData',
        name: 'AlarmData',
        component: () => import('@/views/Mobile/Device/AlarmData.vue')
      },
      {
        path: 'MobileDeviceHealth',
        name: 'MobileDeviceHealth',
        component: () => import('@/views/Mobile/Device/MobileDeviceHealth.vue')
      },
      {
        path: 'MobileDeviceCamera',
        name: 'MobileDeviceCamera',
        component: () => import('@/views/Mobile/Device/MobileDeviceCamera.vue')
      },
      /* 设备地图 */
      {
        path: 'EquipmentMap',
        name: 'EquipmentMap',
        component: () => import('@/views/Mobile/Manage/EquipmentMap/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 巡查巡检 */
      {
        path: 'Inspection',
        name: 'Inspection',
        component: () => import('@/views/Mobile/Manage/Inspection/index.vue'),
        meta: {
          keepAlive: true
        }
      },
      /* 巡查巡检--设备列表 */
      {
        path: 'InspectionFacility',
        name: 'InspectionFacility',
        component: () => import('@/views/Mobile/Manage/Inspection/facility.vue')
      },
      /* 巡查巡检详情 */
      {
        path: 'InspectionDetail',
        name: 'InspectionDetail',
        component: () => import('@/views/Mobile/Manage/Inspection/details.vue'),
        meta: {
          keepAlive: true
        }
      },

      /* 工单 */
      {
        path: 'WorkOrderHandling',
        name: 'WorkOrderHandling',
        component: () =>
          import('@/views/Mobile/Manage/WorkOrderHandling/index.vue'),
        meta: {
          keepAlive: true
        }
      },
      /* 工单详情 */
      {
        path: 'WorkOrderHandlingDetail',
        name: 'WorkOrderHandlingDetail',
        component: () =>
          import('@/views/Mobile/Manage/WorkOrderHandling/details.vue')
      },
      /* 报事报修 */
      {
        path: 'ReportForRepairs',
        name: 'ReportForRepairs',
        component: () =>
          import('@/views/Mobile/Manage/ReportForRepairs/index.vue'),
        meta: {
          keepAlive: true
        }
      },
      /* 报事报修详情 */
      {
        path: 'ReportForRepairsDetail',
        name: 'ReportForRepairsDetail',
        component: () =>
          import('@/views/Mobile/Manage/ReportForRepairs/details.vue')
        // meta: {
        //   keepAlive: true
        // }
      }
    ],
    meta: {
      single: true,
      anonymous: true
    }
  },
  // 综管
  {
    path: '/MobileManageHome',
    name: 'MobileManageHome',
    props: true,
    component: () => import('@/views/Mobile/Manage/MobileManageHome/index.vue'),
    children: [
      /* 打卡 */
      {
        path: 'ClockIn',
        name: 'ClockIn',
        component: () => import('@/views/Mobile/Manage/ClockIn/index.vue')
      },
      /* 请假 */
      {
        path: 'AskForLeave',
        name: 'AskForLeave',
        component: () => import('@/views/Mobile/Manage/AskForLeave/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 请假详情 */
      {
        path: 'AskForLeaveDeatail',
        name: 'AskForLeaveDeatail',
        component: () =>
          import('@/views/Mobile/Manage/AskForLeave/components/detail.vue')
      },
      /* 请假审批 */
      {
        path: 'AskForLeaveExamine',
        name: 'AskForLeaveExamine',
        component: () =>
          import('@/views/Mobile/Manage/AskForLeave/components/examine.vue')
      },
      /* 勤务人员 */
      {
        path: 'MobileTeamMember',
        name: 'MobileTeamMember',
        component: () =>
          import('@/views/Mobile/Manage/MobileTeamMember/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },

      /* 勤务人员 */
      {
        path: 'MySchedulingQuery',
        name: 'MySchedulingQuery',
        component: () =>
          import('@/views/Mobile/Manage/MySchedulingQuery/index.vue'),
        meta: {
          keepAlive: false //true缓存 false不缓存
        }
      },

      /* 排班表 */
      {
        path: 'MobileDutyWorkArranged',
        name: 'MobileDutyWorkArranged',
        component: () =>
          import('@/views/Mobile/Manage/MobileDutyWorkArranged/index.vue')
      },
      /* 排查单位查询 */
      {
        path: 'MobileTroubleshooting',
        name: 'MobileTroubleshooting',
        component: () =>
          import('@/views/Mobile/Manage/MobileTroubleshooting/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 排查单位详情 */
      {
        path: 'MobileTroubleshootingDetail',
        name: 'MobileTroubleshootingDetail',
        component: () =>
          import('@/views/Mobile/Manage/MobileTroubleshootingDetail.vue')
      },
      /* 物资库存 */
      {
        path: 'MobileMaterialStock',
        name: 'MobileMaterialStock',
        component: () =>
          import('@/views/Mobile/Manage/MobileMaterialStock/index.vue')
      },
      /* 物资库存分类 */
      {
        path: 'MobileMaterialStockClassification',
        name: 'MobileMaterialStockClassification',
        component: () =>
          import(
            '@/views/Mobile/Manage/MobileMaterialStockClassification/index.vue'
            )
      },
      /* 物资库存详情 */
      {
        path: 'MobileMaterialStockDetail',
        name: 'MobileMaterialStockDetail',
        component: () =>
          import('@/views/Mobile/Manage/MobileMaterialStockDetail/index.vue')
      },
      /* 物资采购申请 */
      {
        path: 'MobileMaterialPurchasing',
        name: 'MobileMaterialPurchasing',
        component: () =>
          import('@/views/Mobile/Manage/MobileMaterialPurchasing.vue')
      },
      {
        path: 'MobileMaterialStockAnalysis',
        name: 'MobileMaterialStockAnalysis',
        component: () =>
          import('@/views/Mobile/Manage/MobileMaterialStockAnalysis.vue')
      },
      /* 隐患档案查询 */
      {
        path: 'MobileTrainingPlan',
        name: 'MobileTrainingPlan',
        component: () =>
          import('@/views/Mobile/Manage/MobileTrainingPlan/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 培训计划详情 */
      {
        path: 'MobileTrainingPlanDetail',
        name: 'MobileTrainingPlanDetail',
        component: () =>
          import('@/views/Mobile/Manage/MobileTrainingPlanDetail/index.vue')
      },
      /* 隐患查询 */
      {
        path: 'MobileSaftyDanger',
        name: 'MobileSaftyDanger',
        component: () =>
          import('@/views/Mobile/Manage/MobileSaftyDanger/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 隐患查询详情 */
      {
        path: 'MobileSaftyDangerDetail',
        name: 'MobileSaftyDangerDetail',
        component: () =>
          import('@/views/Mobile/Manage/MobileSaftyDangerDetail.vue')
      },
      /* 搜索 */
      {
        path: 'MobileSearchIndividual',
        name: 'MobileSearchIndividual',
        component: () =>
          import('@/views/Mobile/Manage/MobileSearchIndividual.vue')
      },
      /* 安全排查计划详情 */
      {
        path: 'MobileSaftyDangerCheckPlanDetail',
        name: 'MobileSaftyDangerCheckPlanDetail',
        component: () =>
          import(
            '@/views/Mobile/Manage/MobileSaftyDangerCheckPlanDetail/index.vue'
            ),
        meta: {
          keepAlive: false //true缓存 false不缓存
        }
      },
      /* 安全排查计划详情未排查 */
      {
        path: 'MobileSaftyTreatCheckPlanDetail',
        name: 'MobileSaftyTreatCheckPlanDetail',
        component: () =>
          import(
            '@/views/Mobile/Manage/MobileSaftyTreatCheckPlanDetail/index.vue'
            )
      },
      /* 安全排查计划 */
      {
        path: 'MobileSaftyDangerCheckPlan',
        name: 'MobileSaftyDangerCheckPlan',
        component: () =>
          import('@/views/Mobile/Manage/MobileSaftyDangerCheckPlan/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },

      /* 个人勤务详情 */
      {
        path: 'MobileTeamMemberCalendar',
        name: 'MobileTeamMemberCalendar',
        component: () =>
          import('@/views/Mobile/Manage/MobileTeamMemberCalendar/index.vue')
      },

      /* 安全排查方案 */
      {
        path: 'securityInvestigationPlan',
        name: 'securityInvestigationPlan',
        component: () =>
          import('@/views/Mobile/Manage/securityInvestigationPlan/index.vue')
      },
      /* 勤务岗位监测 */
      {
        path: 'ServicePostMonitoring',
        name: 'ServicePostMonitoring',
        component: () =>
          import('@/views/Mobile/Manage/ServicePostMonitoring/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /* 安全目标 */
      {
        path: 'safetyObjectives',
        name: 'safetyObjectives',
        component: () =>
          import('@/views/Mobile/Manage/SafetyObjectives')
      },
      /* 安全年度计划 */
      {
        path: 'annualSafetyPlan',
        name: 'annualSafetyPlan',
        component: () =>
          import('@/views/Mobile/Manage/AnnualSafetyPlan')
      },
      /* 安全责任书 */
      {
        path: 'safetyResponsibilityLetter',
        name: 'safetyResponsibilityLetter',
        component: () =>
          import('@/views/Mobile/Manage/SafetyResponsibilityLetter')
      },
      /* 安全培训方案 */
      {
        path: 'securityTrainingProgram',
        name: 'securityTrainingProgram',
        component: () =>
          import('@/views/Mobile/Manage/SecurityTrainingProgram')
      },
      /* 安全培训查询 */
      {
        path: 'securityTrainingQuery',
        name: 'securityTrainingQuery',
        component: () =>
          import('@/views/Mobile/Manage/SecurityTrainingQuery')
      },
      /* 安全排查方案 */
      {
        path: 'securityInvestigationPlans',
        name: 'securityInvestigationPlans',
        component: () =>
          import('@/views/Mobile/Manage/SecurityInvestigationPlans')
      },
      /* 安全排查计划 */
      {
        path: 'securityInvestigationProject',
        name: 'securityInvestigationProject',
        component: () =>
          import('@/views/Mobile/Manage/SecurityInvestigationProject')
      },
      /* 物资采购申请 */
      {
        path: 'materialsPurchaseRequest',
        name: 'materialsPurchaseRequest',
        component: () =>
          import('@/views/Mobile/Manage/materialsPurchaseRequest')
      },
      /* 物资采购申请添加 */
      {
        path: 'materialsPurchaseRequestAdd',
        name: 'materialsPurchaseRequestAdd',
        component: () =>
          import('@/views/Mobile/Manage/materialsPurchaseRequest/add')
      },
      /* 物资采购申请添加明细 */
      {
        path: 'materialsPurchaseRequestAddDetail',
        name: 'materialsPurchaseRequestAddDetail',
        component: () =>
          import('@/views/Mobile/Manage/materialsPurchaseRequest/addDetail')
      },
      /* 物资采购申请详情 */
      {
        path: 'materialsPurchaseRequestDetail',
        name: 'materialsPurchaseRequestDetail',
        component: () =>
          import('@/views/Mobile/Manage/materialsPurchaseRequest/detail')
      },

      /* 物资领用申请 */
      {
        path: 'materialsRequisition',
        name: 'materialsRequisition',
        component: () =>
          import('@/views/Mobile/Manage/materialsRequisition')
      },
      /* 物资采购申请添加 */
      {
        path: 'materialsRequisitionAdd',
        name: 'materialsRequisitionAdd',
        component: () =>
          import('@/views/Mobile/Manage/materialsRequisition/add')
      },
      /* 物资采购申请添加明细 */
      {
        path: 'materialsRequisitionAddDetail',
        name: 'materialsRequisitionAddDetail',
        component: () =>
          import('@/views/Mobile/Manage/materialsRequisition/addDetail')
      },
      /* 物资采购申请详情 */
      {
        path: 'materialsRequisitionDetail',
        name: 'materialsRequisitionDetail',
        component: () =>
          import('@/views/Mobile/Manage/materialsRequisition/detail')
      },


      /*基础管理*/
      /*日志管理*/
      {
        path: 'LogsPage',
        name: 'LogsPage',
        component: () => import('@/views/Mobile/Manage/LogsPage/index.vue'),
        meta: {
          keepAlive: true //true缓存 false不缓存
        }
      },
      /*日志管理---详情*/
      {
        path: 'LogsPageDetails',
        name: 'LogsPageDetails',
        component: () => import('@/views/Mobile/Manage/LogsPage/details.vue')
      },
      /*群组管理*/
      {
        path: 'GroupManagement',
        name: 'GroupManagement',
        component: () =>
          import('@/views/Mobile/Manage/GroupManagement/index.vue')
      },
      /*群组管理 --- 新增编辑*/
      {
        path: 'GroupManagementForm',
        name: 'GroupManagementForm',
        component: () =>
          import(
            '@/views/Mobile/Manage/GroupManagement/components/GroupManagementForm/index.vue'
            )
      },
      /*人员管理*/
      {
        path: 'personnelManagement',
        name: 'personnelManagement',
        component: () => import('@/views/Mobile/Manage/PersonnelManagement'),
        meta: {
          keepAlive: true
        }
      },
      /*人员管理*/
      {
        path: 'accountDetails',
        name: 'accountDetails',
        component: () => import('@/views/Mobile/Manage/AccountDetails')
      },
      /** 移动执法 */
      /* 案件录入*/
      {
        path: 'caseEntry',
        name: 'caseEntry',
        component: () => import('@/views/Mobile/Manage/CaseEntry'),
        meta: {
          keepAlive: true
        }
      },
      /* 现场处置*/
      {
        path: 'caseHandling',
        name: 'caseHandling',
        component: () => import('@/views/Mobile/Manage/CaseHandling'),
        meta: {
          keepAlive: true
        }
      },
      /* 处置审批 */
      {
        path: 'disposalApproval',
        name: 'disposalApproval',
        component: () => import('@/views/Mobile/Manage/DisposalApproval'),
        meta: {
          keepAlive: true
        }
      },
      /* 案件督办-草稿详情 */
      {
        path: 'draftDetails',
        name: 'draftDetails',
        component: () => import('@/views/Mobile/Manage/DraftDetails')
      },
      /* 案件督办-处置详情 */
      {
        path: 'disposalDetails',
        name: 'disposalDetails',
        component: () => import('@/views/Mobile/Manage/DisposalDetails')
      },
      /* 简单案件录入 */
      {
        path: 'simpleEventEntry',
        name: 'simpleEventEntry',
        component: () => import('@/views/Mobile/Manage/SimpleEventEntry')
      },
      /* 一般案件录入 */
      {
        path: 'generalEventEntry',
        name: 'generalEventEntry',
        component: () => import('@/views/Mobile/Manage/GeneralEventEntry')
      },
      /* 案件录入详情 */
      {
        path: 'informationCaseRevise',
        name: 'informationCaseRevise',
        component: () =>
          import('@/views/Mobile/Manage/informationCase/components/revise.vue')
      },
      /* 我的案件*/
      {
        path: 'caseExamine',
        name: 'caseExamine',
        component: () => import('@/views/Mobile/Manage/caseExamine'),
        meta: {
          keepAlive: true
        }
      },
      /* 我的案件---审批*/
      {
        path: 'caseExamineDetails',
        name: 'caseExamineDetails',
        component: () => import('@/views/Mobile/Manage/caseExamine/routeComponents/details.vue')
      },
      /* 待办事宜*/
      {
        path: 'myCase',
        name: 'myCase',
        component: () => import('@/views/Mobile/Manage/MyCase')
      },
      /* 待办事宜-审批*/
      {
        path: 'myCaseDetails',
        name: 'myCaseDetails',
        component: () => import('@/views/Mobile/Manage/MyCase/details')
      },
      /* 调查取证*/ {
        path: 'survey',
        name: 'survey',
        component: () => import('@/views/Mobile/Manage/survey')
      },
      /* 调查取证---详情*/ {
        path: 'surveyDetails',
        name: 'surveyDetails',
        component: () => import('@/views/Mobile/Manage/survey/details')
      },
      /* 案件处罚*/ {
        path: 'penalize',
        name: 'penalize',
        component: () => import('@/views/Mobile/Manage/penalize')
      },
      /* 案件处罚---详情*/ {
        path: 'penalizeDetails',
        name: 'penalizeDetails',
        component: () => import('@/views/Mobile/Manage/penalize/details')
      },
      /* 案件结案*/ {
        path: 'settleCase',
        name: 'settleCase',
        component: () => import('@/views/Mobile/Manage/settleCase')
      },
      /* 案件结案---详情*/ {
        path: 'settleCaseDetails',
        name: 'settleCaseDetails',
        component: () => import('@/views/Mobile/Manage/settleCase/details')
      },

      /* 案件督办*/ {
        path: 'supervisionCase',
        name: 'supervisionCase',
        component: () => import('@/views/Mobile/Manage/SupervisionCase')
      },
      /* 案件督办详情 */
      {
        path: 'supervisionCaseDetail',
        name: 'supervisionCaseDetail',
        component: () =>
          import(
            '@/views/Mobile/Manage/SupervisionCase/components/details.vue'
            ),
        meta: {
          keepAlive: true
        }
      },
      /* 综合评价*/
      {
        path: 'comprehensiveEvaluation',
        name: 'comprehensiveEvaluation',
        component: () => import('@/views/Mobile/Manage/ComprehensiveEvaluation')
      },
      /* 领导看板 */
      {
        path: 'leadershipKanban',
        name: 'leadershipKanban',
        component: () => import('@/views/Mobile/Manage/LeadershipKanban')
      }
    ],
    meta: {
      single: true,
      anonymous: true
    }
  }
]
