import 'babel-polyfill'
import Vue from 'vue'
import App from './App.vue'
import store from './store'
import router from './router'
import Print from '@/plugs/print' // 打印插件 源码修改过 getStyle方法

import '@/assets/css/element-custom.scss'
import ElementUI from 'element-ui'
import i18n from '@/lang/index.js'
import moment from 'moment' // 日期格式化插件
import VueUeditorWrap from 'vue-ueditor-wrap' // 引入富文本组件
import echarts from 'echarts' // 引入echarts
import '@/directive.js'
import req from '@/request.js'
import deepmerge from 'deepmerge'
import validate from '@/validate.js'
import dict from '@/lang/dict.js'
import HtSubmitButton from '@/components/common/HtSubmitButton.vue'
import HtDeleteButton from '@/components/common/HtDeleteButton.vue'
import ExportData from '@/components/ImportExportData/ExportData/ExportData.vue'
import ImportData from '@/components/ImportExportData/ImportData/ImportData.vue'
import HtLoadData from '@/components/common/HtLoadData.vue'
import utils from '@/utils.js'
import Formulas from '@/formulas.js'
import dayjs from 'dayjs'

import Viewer from 'v-viewer' // 图片预览插件
import 'viewerjs/dist/viewer.css'

import Video from 'video.js'
import 'video.js/dist/video-js.css'
import CollapseTransition from 'element-ui/lib/transitions/collapse-transition'
// 大屏组件
import dataV from '@jiaminghi/data-view'
// 引入字典
import DictSelect from '@/components/dict/DictSelect.vue'
import dictUtils from '@/components/dict/DictSelectUtils'
// 引入公司选择器
import CompanyInfoSelector from '@/components/selector/companyInfoSelector.vue'
// 引入用户选择器
import CompanyUserSelector from '@/components/selector/companyUserSelector.vue'

// 获取字典名字
Vue.prototype.getDictName = (dictCode, value) => {
  let name = ''
  const dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems.forEach(item => {
    if (item.value == value) {
      name = item.name
    }
  })
  return name
}
Vue.prototype.dayjs = dayjs
Vue.use(dataV)
// 获取字典数据
Vue.prototype.getDictData = dictCode => {
  const arr = []
  const dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems.forEach(item => {
    arr.push({
      text: item.name,
      value: item.value
    })
  })
  return arr
}

Vue.prototype.getDictDataSearch = dictCode => {
  const arr = []
  const dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems.forEach(item => {
    arr.push({
      value: item.name,
      key: item.value
    })
  })
  return arr
}
Vue.prototype.getDate = () => {
  const nowDate = new Date()
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate()
  }
  const newmonth = date.month > 10 ? date.month : '0' + date.month
  const day = date.date > 10 ? date.date : '0' + date.date
  date = date.year + '-' + newmonth + '-' + day
  return date
}

import {
  NavBar,
  Tabbar,
  TabbarItem,
  List,
  PullRefresh,
  Card,
  Sticky,
  Tag,
  Icon,
  Cell,
  CellGroup,
  Picker,
  Popup,
  Grid,
  GridItem,
  Empty,
  Calendar,
  DropdownMenu,
  DropdownItem,
  Button,
  Col,
  Row,
  Tab,
  Tabs,
  Search,
  Dialog,
  Form,
  Field,
  Toast,
  Panel,
  Notify,
  DatetimePicker,
  TreeSelect,
  Uploader,
  RadioGroup,
  Radio,
  Cascader,
  ActionSheet,
  Step,
  Steps,
  ImagePreview,
  Collapse,
  CollapseItem,
  Checkbox,
  CheckboxGroup,
  Popover,
  Overlay,
  Loading,
  Image as VanImage
} from 'vant'

Vue.use(VanImage)
Vue.use(Collapse)
Vue.use(CollapseItem)
Vue.use(ImagePreview)
Vue.use(Step)
Vue.use(Steps)
Vue.use(ActionSheet)
Vue.use(NavBar)
Vue.use(Tabbar)
Vue.use(TabbarItem)
Vue.use(List)
Vue.use(PullRefresh)
Vue.use(Card)
Vue.use(Sticky)
Vue.use(Tag)
Vue.use(Icon)
Vue.use(Cell)
Vue.use(CellGroup)
Vue.use(Picker)
Vue.use(Popup)
Vue.use(Grid)
Vue.use(GridItem)
Vue.use(Empty)
Vue.use(Calendar)
Vue.use(DropdownMenu)
Vue.use(DropdownItem)
Vue.use(Button)
Vue.use(Col)
Vue.use(Row)
Vue.use(Tab)
Vue.use(Tabs)
Vue.use(Search)
Vue.use(Dialog)
Vue.use(Form)
Vue.use(Field)
Vue.use(Toast)
Vue.use(Panel)
Vue.use(DatetimePicker)
Vue.use(Notify)
Vue.use(TreeSelect)
Vue.use(Uploader)
Vue.use(RadioGroup)
Vue.use(Radio)
Vue.use(Cascader)
Vue.use(Checkbox)
Vue.use(CheckboxGroup)
Vue.use(Popover)
Vue.use(Overlay)
Vue.use(Loading)

import 'vant/lib/nav-bar/style'
import 'vant/lib/list/style'
import 'vant/lib/pull-refresh/style'
import 'vant/lib/card/style'
import 'vant/lib/sticky/style'
import 'vant/lib/tabbar/style'
import 'vant/lib/tabbar-item/style'
import 'vant/lib/tag/style'
import 'vant/lib/icon/style'
import 'vant/lib/cell/style'
import 'vant/lib/cell-group/style'
import 'vant/lib/picker/style'
import 'vant/lib/popup/style'
import 'vant/lib/grid/style'
import 'vant/lib/grid-item/style'
import 'vant/lib/empty/style'
import 'vant/lib/calendar/style'
import 'vant/lib/dropdown-menu/style'
import 'vant/lib/dropdown-item/style'
import 'vant/lib/button/style'
import 'vant/lib/col/style'
import 'vant/lib/row/style'
import 'vant/lib/tab/style'
import 'vant/lib/tabs/style'
import 'vant/lib/search/style'
import 'vant/lib/dialog/style'
import 'vant/lib/form/style'
import 'vant/lib/field/style'
import 'vant/lib/toast/style'
import 'vant/lib/panel/style'
import 'vant/lib/datetime-picker/style'
import 'vant/lib/tree-select/style'
import 'vant/lib/uploader/style'
import 'vant/lib/radio-group/style'
import 'vant/lib/radio/style'
import 'vant/lib/cascader/style'
import 'vant/lib/action-sheet/style'
import 'vant/lib/step/style'
import 'vant/lib/steps/style'
import 'vant/lib/image-preview/style'
import 'vant/lib/checkbox/style'
import 'vant/lib/checkbox-group/style'
import 'vant/lib/popover/style'
import 'vant/lib/overlay/style'
import 'vant/lib/loading/style'
import 'vant/lib/collapse/style'
import 'vant/lib/collapse-item/style'


// import 'vant/lib/notify/style'

// 侧边导航事件
import eventBus from './api/bus.js'

Vue.use(eventBus)
// 菜单图标
import svgIcon from '@/components/global/svgIcon.vue'

Vue.prototype.$video = Video

Vue.config.debug = true

Vue.prototype.$http = req

// 字符串解析和序列化字符串
import qs from 'qs'

Vue.prototype.qs = qs

Vue.use(Viewer, {
  defaultOptions: {
    zIndex: 9999,
    toolbar: true
  }
})
Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value),
  size: 'medium'
})

Vue.use(Print)
Vue.use(Formulas)

Vue.component('svgIcon', svgIcon)
Vue.component('HtSubmitButton', HtSubmitButton)
Vue.component('HtDeleteButton', HtDeleteButton)
Vue.component('DictSelect', DictSelect)
Vue.component('CompanyInfoSelector', CompanyInfoSelector)
Vue.component('CompanyUserSelector', CompanyUserSelector)
Vue.component('HtLoadData', HtLoadData)
Vue.filter('formatDate', function(value, pattern = 'YYYY-MM-DD HH:mm:ss') {
  if (!value) {
    return ''
  }
  return moment(value).format(pattern)
})
Vue.component('vue-ueditor-wrap', VueUeditorWrap)
Vue.component(CollapseTransition.name, CollapseTransition)
Vue.component('ExportData', ExportData)
Vue.component('ImportData', ImportData)
// Vue.prototype.$echarts = echarts

window.app = new Vue({
  store,
  router,
  i18n,
  render: function(createElement) {
    if (
      '-ms-scroll-limit' in document.documentElement.style &&
      '-ms-ime-align' in document.documentElement.style
    ) {
      window.addEventListener(
        'hashchange',
        () => {
          var currentPath = window.location.hash.slice(1)
          if (this.$route.path !== currentPath) {
            this.$router.push(currentPath)
          }
        },
        false
      )
    }
    return createElement(App)
  }
}).$mount('#root')

const validateLocal = localStorage.getItem('lang')
const currentLocal = validateLocal || 'zh-CN'
// app.$validator.locale = currentLocal

if (app.$validator) {
  for (const rule in validate) {
    app.$validator.rules[rule] = validate[rule]
  }
  app.$validator.dictionary.container = deepmerge(
    dict,
    app.$validator.dictionary.container, {
      clone: true
    }
  )
}

// 日期控件格式化
if (currentLocal == 'zh-CN') {
  moment.locale('zh-cn')
} else {
  moment.locale('en')
}

// 日期格式化
Vue.prototype.getDate = () => {
  const nowDate = new Date()
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate()
  }
  const newmonth = date.month >= 10 ? date.month : '0' + date.month
  const day = date.date >= 10 ? date.date : '0' + date.date
  date = date.year + '-' + newmonth + '-' + day
  return date
}

// 时间格式化
Vue.prototype.getTime = () => {
  const nowDate = new Date()
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate(),
    hours: nowDate.getHours(), // 获取当前小时数(0-23)
    minutes: nowDate.getMinutes(), // 获取当前分钟数(0-59)
    seconds: nowDate.getSeconds() // 获取当前秒数(0-59)
  }
  const newmonth = date.month >= 10 ? date.month : '0' + date.month
  const day = date.date >= 10 ? date.date : '0' + date.date
  const hours = date.hours >= 10 ? date.hours : '0' + date.hours
  const minutes = date.minutes >= 10 ? date.minutes : '0' + date.minutes
  const seconds = date.seconds >= 10 ? date.seconds : '0' + date.seconds
  date = date.year + '-' + newmonth + '-' + day + ' ' + hours + ':' + minutes + ':' + seconds
  return date
}

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = 'bottom'
