import req from '@/request.js'
const portal = window.context.portal
export default {
  // 人员信息查询
  userQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/user/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增人员信息
  addUserInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/user/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 更新人员信息
  updateUserInfo(data) {
    return new Promise((resolve, reject) => {
      req.put(portal + `/device/base/user/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据id查询人员信息
  userInfoDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/base/user/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量删除人员信息
  removeInfos(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/base/user/`, ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量删除单位信息
  removeUnits(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/base/company/?ids=` + ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 查询单位
  loadUnit(data, cb) {
    req.post(portal + `/device/base/company/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询单位详情
  UnitInfoDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/base/company/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 人员扩展信息
  userExtendInfo(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/base/paramsConf/getConfValue`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取人员详情
  CompanyUser(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/company/getCompanyAndUser`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
