import req from '@/request.js'
const portal = window.context.portal
export default {
  // 分页查询
  queryData(data, cb) {
    req.post(portal + `/case/supervise/query`, data).then(res => {
      cb(res.data)
    })
  },
  //通过id获取详情
  detailData(data, cb) {
    req.get(portal + `/case/supervise/` + data).then(res => {
      cb(res.data)
    })
  },
  // 领导批示保存
  supervise(data, cb) {
    req.put(portal + `/case/supervise/`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取所属部门
  byParentAndDemToTree(data, cb) {
    req.get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrg`).then(res => {
      cb(res.data)
    })
  },
  //工单查询
  workOrderQuery(data, cb) {
    req
      .post(
        portal + `/deviceInspectionMaintenance/v1/listByPage?isAffirm=false`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  //工单详情
  workOrderDetail(data, cb) {
    req
      .get(portal + `/deviceInspectionMaintenance/v1/details?id=` + data)
      .then(res => {
        cb(res.data)
      })
  }
}
