import req from '@/request.js'
const portal = window.context.portal
export default {
  /*标识牌设备 实时监测 */
  // 分页查询
  signboaerdQuery(data, cb) {
    req.post(portal + `/data/signboaerd/query`, data).then(res => {
      cb(res.data)
    })
  },
  //危险源设备
  hazardQuery(data, cb) {
    req.post(portal + `/data/hazard/query`, data).then(res => {
      cb(res.data)
    })
  },
  //积水设备
  waterQuery(data, cb) {
    req.post(portal + `/data/water/query`, data).then(res => {
      cb(res.data)
    })
  },
  //防暴路障
  deviceDataBarricadeStatus(data, cb) {
    req.post(portal + `/deviceDataBarricadeStatus/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  //根据id查询实体
  accountCode(data, cb) {
    console.log(data);
    req.get(portal + `/sso/accountCode?code=` + data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询
  getQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/data/signboaerd/query`, data).then(res => {
        resolve(res.data || {})
      }).catch(err => {
        reject(err)
      })
    })
  }
}
