import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检台账表格数据
export function tableData(data = {}, query) {
  return new Promise((resolve, reject) => {
    let newQuery = {}
    Object.keys(query).forEach(key => {
      if (query[key]) newQuery[key] = query[key]
    })
    req.post(portal + `/deviceInspectionResult/v1/findByPage?${qs.stringify(newQuery)}`, data)
      .then(res => resolve(res.data))
      .catch(err => reject(err))
  })
}

// 获取设备产品分类列表
export function getProductTree(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/product/type/getProductTree`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取计划列表
export function deviceInspectionPlan(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/query`, {
      pageBean: {pageSize: -1}
    })
      .then(res => resolve(res.data))
      .catch(err => reject(err))
  })
}

// 获取设备列表(不分页)
export function deviceTable(productId = '') {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/info/query`, {
      pageBean: {pageSize: -1}, params: {productId}
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// (不分页)
export function getByParentAndDemToTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/org/v1/orgs/getByParentAndDemToTree`, {
      demId: '1491618454686535680'
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增设备巡查台账
export function ledgerAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/add`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备巡查台账详情
export function ledgerDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionResult/v1/details?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改设备巡查台账
export function ledgerEdit(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/inspectionEdit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除设备巡查台账
export function ledgerRemove(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/deviceInspectionResult/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 生成故障工单
export function faultWorkOrder(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/pushData?id=${id}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}








