import req from "@/request.js";
import { blob } from "d3";

const portal = window.context.portal;
export default {
    //字典
    getSys(data, cb) {
        req.post(portal + `/sys/sysDictionary/v1/queryDictItemsByCode`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 河道最新水情分页
    ListGet(data, cb) {
        req.post(portal + `/biz/water/monitor/riverHistoryQuery`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 水库水位水库下拉
    getRsnm(data, cb) {
        req.post(portal + `/att/res/base/findAll`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 水库水位测站下拉
    getStnms(data, cb) {
        req.post(portal + `/att/res/base/findAll`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 行政区查询接口
    getbasAdName(data, cb) {
        req.post(portal + `/sys/sysAreas/v1/townTree`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 河道水位河流下拉树
    getrvName(data, cb) {
        req.post(portal + `/att/rv/base/findAll`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 河道测站下拉
    getStcd(data, cb) {
        req.post(portal + `/biz/water/monitor/findRiverList`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 曲线图数据
    getChartsList(data, cb) {
        req.post(portal + `/biz/monitor/curve/riverLatestList`, data).then(rep => {
            cb(rep.data);
        });
    },
	//导出excl
	riverHistoryExport(data,cb){
		req.post(portal + `/biz/water/monitor/riverHistoryExport`, data,'blob').then(rep => {
		    cb(rep.data);
		});
	}
}