import req from '@/request.js'
const portal = window.context.portal
export default {
	// 线上请求天气
	getWeather(cb) {
		req
			.get(
				'/v3/weather/weatherInfo?city=500109&key=1af220913a77b2622eb27cfc779de72d&extensions=all'
			)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	// 本地测试
	// getWeather(cb) {
	//     req.get('/weatherApi/v3/weather/weatherInfo?city=500109&key=1af220913a77b2622eb27cfc779de72d&extensions=all').then(rep => {
	//         if(rep.data){
	//             cb(rep.data);
	//         }
	//     });
	// },
	//行政基础概况
	govSector(cb) {
		req.post(portal + '/biz/warn/statistics/govSector').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//水位报警统计
	swWarning(cb) {
		req.post(portal + '/biz/warn/statistics/swWarning').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//雨量报警统计
	ylWarning(cb) {
		req.post(portal + '/biz/warn/statistics/ylWarning').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//测站正常率
	station(cb) {
		req.post(portal + '/biz/warn/statistics/station').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//工程概况
	project(data, cb) {
		req
			.get(portal + '/biz/warn/statistics/project?status=' + data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	//生态流量
	flowList(data, cb) {
		req
			.post(portal + '/biz/warn/statistics/flowList', data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	//临界河道水位排行
	criticalRiver(cb) {
		req.post(portal + '/biz/warn/statistics/criticalRiverList').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//临界水库水位排行
	criticalRsvr(cb) {
		req.post(portal + '/biz/warn/statistics/criticalRsvrList').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//当年取水量统计
	yearWaterPaln(data, cb) {
		req.post(portal + '/biz/warn/statistics/yearWaterPaln', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//日累计降雨排行
	precipitation(data, cb) {
		req
			.get(portal + '/biz/warn/statistics/precipitation?appType=' + data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	//实时水情
	realTimeWaterList(data, cb) {
		req
			.post(portal + '/biz/warn/statistics/realTimeWaterList', data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	// 实时雨情
	realTimeRainList(data, cb) {
		req
			.post(portal + '/biz/warn/statistics/realTimeRainList', data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	//实时水情
	realTimeWaterLists(data, cb) {
		req
			.post(portal + '/biz/warn/statistics/realTimeWaterList', data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	// 实时雨情
	realTimeRainLists(data, cb) {
		req
			.post(portal + '/biz/warn/statistics/realTimeRainList', data)
			.then(rep => {
				if (rep.data) {
					cb(rep.data)
				}
			})
	},
	//获取海康地址
	haiKang(cb) {
		req.post(portal + '/haikang/v1/getTokenUrl').then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 水库水位水库下拉
	getRsnm(data, cb) {
		req.post(portal + `/att/res/base/findAll`, data).then(rep => {
			cb(rep.data);
		});
	},
	//所有报警统计
	allWarningList(data, cb) {
		req.post(portal + '/biz/warn/statistics/allWarning', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
}