import req from "@/request.js";
const portal = window.context.portal;
export default {
	//获取水库列表
	findResList(data, cb) {
		req.post(portal + '/biz/res/gis/findResList', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//雨情监测
	pptnLatestList(data, cb) {
		req.post(portal + '/biz/res/statistics/pptnLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//水情监测
	rsvrLatestList(data, cb) {
		req.post(portal + '/biz/res/statistics/rsvrLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取监测站下拉
	monitoring(data, cb) {
		req.post(portal + '/biz/station/gq/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//位移曲线图
	dammvData(data, cb) {
		req.post(portal + '/biz/res/gis/dammvData', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//渗流曲线图
	damspgData(data, cb) {
		req.post(portal + '/biz/res/gis/damspgData', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//渗压曲线图
	damspprData(data, cb) {
		req.post(portal + '/biz/res/gis/damspprData', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},


	//获取水电站下拉列表
	findAll(data, cb) {
		req.post(portal + '/biz/res/gis/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//根据水电站获取生态流量
	flowList(data, cb) {
		req.post(portal + '/biz/res/gis/flowList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取水雨情测站列表
	findStList(data, cb) {
		req.post(portal + '/biz/res/gis/findStList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//雨情测报数据
	gisPptnLatestList(data, cb) {
		req.post(portal + '/biz/res/gis/pptnLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取工情测站列表
	findGqStation(data, cb) {
		req.post(portal + '/biz/res/gis/findGqStation', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//预警设施列表
	alarmList(data, cb) {
		req.post(portal + '/biz/res/gis/alarmList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取取水点列表
	stationPage(data, cb) {
		req.post(portal + '/biz/res/gis/stationPage', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//根据取水户获取取水计划列表
	waterPlanLis(data, cb) {
		req.post(portal + '/biz/res/gis/waterPlanList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//取水点测报数据
	waterDataList(data, cb) {
		req.post(portal + '/biz/res/gis/waterDataList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//查询行政区划
	querySysAreas(data, cb) {
		req.post(portal + '/sys/sysAreas/v1/querySysAreas', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取河流下拉树
	baseFindAll(data, cb) {
		req.post(portal + '/att/rv/base/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取区域相关监测站和水利工程统计信息
	countStation(data,cb){
		req.post(portal + '/biz/res/gis/countStation', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//
	hdswLatestList(data,cb){
		req.post(portal + '/biz/res/gis/hdswLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//水库名称
	findRiverList(data,cb){
		req.post(portal + '/biz/water/monitor/findRiverList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},







	//监测预警
	// 实时水情
	waterRegime(data, cb) {
		req.post(portal + '/biz/res/gis/waterLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//实时雨情
	RealTimeRain(data, cb) {
		req.post(portal + '/biz/res/gis/realPptnList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//历史雨情
	waterHistoryList(data, cb) {
		req.post(portal + '/biz/res/gis/waterHistoryList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},

	//河道水位测报数据
	waterRegimehd(data, cb) {
		req.post(portal + '/biz/res/gis/hdswLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	
	//水库水位测报数据
	waterRegimesk(data, cb) {
		req.post(portal + '/biz/res/gis/resLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//日降雨量
	dayYlList(data,cb){
		req.post(portal+'/biz/res/gis/dayYlList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//取水监测
	waterPaperList(data,cb){
		req.post(portal+'/biz/res/gis/waterPaperList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//实时位移
	dammvList(data,cb){
		req.post(portal+'/biz/res/gis/dammvList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//实时渗流
	damspgList(data,cb){
		req.post(portal+'/biz/res/gis/damspgList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//实时渗压
	damspprList(data,cb){
		req.post(portal+'/biz/res/gis/damspprList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//水库名称下拉数据
	geFindAll(data,cb){
		req.post(portal+'/att/res/base/findAll',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	//测压管分页查询
	damsppQuery(data,cb){
		req.post(portal+'/biz/lift/monitor/damsppQuery',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	},
	getDamspprList(data,cb){
		req.post(portal+'/biz/monitor/curve/damspprList',data).then(rep=>{
			if(rep.data){
				cb(rep.data)
			}
		})
	}
}
