/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.things.data.ThingsDataConstants;
import org.jetlinks.community.things.data.operations.AbstractSaveOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.utils.ObjectMappers;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.core.utils.StringBuilderUtils;
import org.jetlinks.core.utils.TimestampUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class RowModeSaveOperationsBase
extends AbstractSaveOperations {
    public RowModeSaveOperationsBase(ThingsRegistry registry, MetricBuilder metricBuilder, DataSettings settings) {
        super(registry, metricBuilder, settings);
    }

    @Override
    protected final Flux<Tuple2<String, TimeSeriesData>> convertProperties(String templateId, ThingMessage message, Map<String, Object> properties, Map<String, Long> propertySourceTimes) {
        if (MapUtils.isEmpty(properties)) {
            return Flux.empty();
        }
        return this.registry.getThing(message.getThingType(), message.getThingId()).flatMapMany(device -> device.getMetadata().flatMapIterable(metadata -> this.createPropertyTsData(templateId, (ThingMetadata)metadata, message, properties, propertySourceTimes)));
    }

    private List<Tuple2<String, TimeSeriesData>> createPropertyTsData(String templateId, ThingMetadata metadata, ThingMessage message, Map<String, Object> properties, Map<String, Long> propertySourceTimes) {
        ArrayList<Tuple2<String, TimeSeriesData>> data = new ArrayList<Tuple2<String, TimeSeriesData>>(properties.size());
        String metric = this.metricBuilder.createPropertyMetric(message.getThingType(), templateId, message.getThingId());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String property = entry.getKey();
            Object value = entry.getValue();
            PropertyMetadata propertyMetadata = metadata.getPropertyOrNull(property);
            if (value == null || propertyMetadata == null || this.propertyIsIgnoreStorage(propertyMetadata)) continue;
            long timestamp = propertySourceTimes.getOrDefault(property, message.getTimestamp());
            String dataId = this.createPropertyDataId(property, message, timestamp);
            data.add((Tuple2<String, TimeSeriesData>)Tuples.of((Object)metric, (Object)TimeSeriesData.of((long)timestamp, this.createRowPropertyData(dataId, TimestampUtils.toMillis((long)timestamp), message, propertyMetadata, value))));
        }
        return data;
    }

    protected boolean propertyIsIgnoreStorage(PropertyMetadata metadata) {
        return ThingsDataConstants.propertyIsIgnoreStorage(metadata);
    }

    protected boolean useTimestampId(ThingMessage message) {
        return (Boolean)message.getHeaderOrDefault(Headers.useTimestampAsId);
    }

    protected String createPropertyDataId(String property, ThingMessage message, long timestamp) {
        if (!this.useTimestampId(message)) {
            return (String)IDGenerator.SNOW_FLAKE_STRING.generate();
        }
        return DigestUtils.md5Hex((String)StringBuilderUtils.buildString((Object)property, (Object)message, (Object)timestamp, (p, m, ts, builder) -> builder.append(m.getThingId()).append('-').append((String)p).append('-').append(ts)));
    }

    protected Map<String, Object> createRowPropertyData(String id, long timestamp, ThingMessage message, PropertyMetadata property, Object value) {
        LinkedHashMap propertyData = Maps.newLinkedHashMapWithExpectedSize((int)16);
        propertyData.put("id", id);
        propertyData.put(this.metricBuilder.getThingIdProperty(), message.getThingId());
        propertyData.put("timestamp", timestamp);
        propertyData.put("property", property.getId());
        propertyData.put("createTime", System.currentTimeMillis());
        this.fillRowPropertyValue(propertyData, property, value);
        return propertyData;
    }

    protected Number convertNumberValue(Number number) {
        return number;
    }

    protected void fillRowPropertyValue(Map<String, Object> target, PropertyMetadata property, Object value) {
        String convertedValue;
        if (value == null) {
            return;
        }
        DataType type = property.getValueType();
        target.put("type", type.getId());
        if (type instanceof NumberType) {
            Number number;
            NumberType numberType = (NumberType)type;
            Number number2 = number = value instanceof Number ? (Number)((Number)value) : (Number)numberType.convertNumber(value);
            if (number == null) {
                throw new BusinessException("error.cannot_convert", 500, new Object[]{value, type.getId()});
            }
            convertedValue = String.valueOf(number);
            target.put("numberValue", this.convertNumberValue(number));
        } else if (type instanceof DateTimeType) {
            DateTimeType dateTimeType = (DateTimeType)type;
            convertedValue = String.valueOf(value);
            target.put("timeValue", dateTimeType.convert((Object)convertedValue));
        } else if (this.propertyIsJsonStringStorage(property)) {
            convertedValue = value instanceof String ? String.valueOf(value) : ObjectMappers.toJsonString((Object)value);
        } else if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            Map val = objectType.convert(value);
            convertedValue = ObjectMappers.toJsonString((Object)val);
            target.put("objectValue", val);
        } else if (type instanceof ArrayType) {
            ArrayType objectType = (ArrayType)type;
            List val = objectType.convert(value);
            convertedValue = ObjectMappers.toJsonString((Object)val);
            target.put("arrayValue", val);
        } else if (type instanceof GeoType) {
            GeoType geoType = (GeoType)type;
            GeoPoint val = geoType.convert(value);
            convertedValue = String.valueOf(val);
            target.put("geoValue", val);
        } else {
            convertedValue = String.valueOf(value);
        }
        target.put("value", convertedValue);
    }

    boolean propertyIsJsonStringStorage(PropertyMetadata metadata) {
        return ThingsDataConstants.propertyIsJsonStringStorage(metadata);
    }

    @Override
    protected abstract Mono<Void> doSave(String var1, TimeSeriesData var2);

    @Override
    protected abstract Mono<Void> doSave(String var1, Flux<TimeSeriesData> var2);
}

