/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.things.data.ThingsDataConstants;
import org.jetlinks.community.things.data.operations.AbstractSaveOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.utils.ObjectMappers;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.metadata.MetadataFeature;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.core.utils.StringBuilderUtils;
import org.jetlinks.core.utils.TimestampUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class ColumnModeSaveOperationsBase
extends AbstractSaveOperations {
    public ColumnModeSaveOperationsBase(ThingsRegistry registry, MetricBuilder metricBuilder, DataSettings settings) {
        super(registry, metricBuilder, settings);
    }

    protected String createPropertyDataId(ThingMessage message) {
        return DigestUtils.md5Hex((String)StringBuilderUtils.buildString((Object)message, (m, builder) -> builder.append(m.getThingId()).append('-').append(m.getTimestamp())));
    }

    @Override
    protected Flux<Tuple2<String, TimeSeriesData>> convertProperties(String templateId, ThingMessage message, Map<String, Object> properties, Map<String, Long> propertySourceTimes) {
        if (MapUtils.isEmpty(properties)) {
            return Flux.empty();
        }
        return this.registry.getThing(message.getThingType(), message.getThingId()).flatMapMany(device -> device.getMetadata().mapNotNull(metadata -> {
            int size = properties.size();
            String id = this.createPropertyDataId(message);
            LinkedHashMap data = Maps.newLinkedHashMapWithExpectedSize((int)size);
            for (Map.Entry entry : properties.entrySet()) {
                Object value;
                PropertyMetadata propertyMetadata = metadata.getPropertyOrNull((String)entry.getKey());
                if (propertyMetadata == null || ThingsDataConstants.propertyIsIgnoreStorage(propertyMetadata) || null == (value = this.convertPropertyValue(entry.getValue(), propertyMetadata))) continue;
                data.put(entry.getKey(), value);
            }
            if (data.isEmpty()) {
                return null;
            }
            data.put(this.metricBuilder.getThingIdProperty(), message.getThingId());
            data.put("timestamp", TimestampUtils.toMillis((long)message.getTimestamp()));
            data.put("createTime", System.currentTimeMillis());
            data.put("id", id);
            return Tuples.of((Object)this.metricBuilder.createPropertyMetric(message.getThingType(), templateId, message.getThingId()), (Object)TimeSeriesData.of((long)message.getTimestamp(), this.handlePropertiesData((ThingMetadata)metadata, data)));
        }));
    }

    protected Map<String, Object> handlePropertiesData(ThingMetadata metadata, Map<String, Object> properties) {
        return properties;
    }

    protected Object convertPropertyValue(Object value, PropertyMetadata metadata) {
        if (value == null || metadata == null) {
            return value;
        }
        if (this.propertyIsJsonStringStorage(metadata)) {
            return value instanceof String ? String.valueOf(value) : ObjectMappers.toJsonString((Object)value);
        }
        if (metadata.getValueType() instanceof NumberType && value instanceof Number) {
            return this.convertNumberValue((NumberType)metadata.getValueType(), (Number)value);
        }
        if (metadata.getValueType() instanceof Converter) {
            return ((Converter)metadata.getValueType()).convert(value);
        }
        return value;
    }

    protected boolean propertyIsJsonStringStorage(PropertyMetadata metadata) {
        return ThingsDataConstants.propertyIsJsonStringStorage(metadata);
    }

    protected Object convertNumberValue(NumberType<?> type, Number value) {
        return value;
    }

    @Override
    protected abstract Mono<Void> doSave(String var1, TimeSeriesData var2);

    @Override
    protected abstract Mono<Void> doSave(String var1, Flux<TimeSeriesData> var2);

    @Override
    public Flux<Feature> getFeatures() {
        return Flux.concat((Publisher[])new Publisher[]{super.getFeatures(), Flux.just((Object[])new MetadataFeature[]{MetadataFeature.propertyNotModifiable, MetadataFeature.propertyNotInsertable})});
    }
}

