/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.things;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.utils.time.DefaultDateFormatter;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.Interval;
import org.jetlinks.community.tdengine.Point;
import org.jetlinks.community.tdengine.TDengineOperations;
import org.jetlinks.community.tdengine.term.TDengineQueryConditionBuilder;
import org.jetlinks.community.things.data.MetricMetadataManager;
import org.jetlinks.community.things.data.PropertyAggregation;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.utils.ConverterUtils;
import org.jetlinks.community.utils.ObjectMappers;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Predicate3;

class TDengineThingDataHelper
implements Disposable {
    final TDengineOperations operations;
    final MetricMetadataManager metadataManager;
    private static final DateTimeFormatter format;

    public static String convertAggFunction(PropertyAggregation agg) {
        switch (agg.getAgg()) {
            case NONE: {
                throw new BusinessException("error.unsupported_aggregation_condition", 500, new Object[]{agg});
            }
        }
        return agg.getAgg().name().toLowerCase();
    }

    public static boolean isArrayTerm(DataType type, Term term) {
        String termType = term.getTermType().toLowerCase();
        return "btw".equals(termType) || "nbtw".equals(termType) || "in".equals(termType) || "nin".equals(termType);
    }

    public static String getGroupByTime(Interval interval) {
        return "interval(" + interval.toString() + ")";
    }

    public static Object tryConvertList(DataType type, Term term) {
        return ConverterUtils.tryConvertToList((Object)term.getValue(), val -> {
            if (type instanceof Converter) {
                return ((Converter)type).convert(val);
            }
            return val;
        });
    }

    public List<Term> prepareTerms(String metric, List<Term> terms) {
        if (CollectionUtils.isEmpty(terms)) {
            return terms;
        }
        for (Term term : terms) {
            if (("timestamp".equals(term.getColumn()) || "_ts".equals(term.getColumn())) && term.getValue() != null) {
                term.setColumn("_ts");
                term.setValue(TDengineThingDataHelper.prepareTimestampValue(term.getValue(), term.getTermType()));
            } else {
                this.metadataManager.getColumn(metric, term.getColumn()).ifPresent(meta -> {
                    DataType type = meta.getValueType();
                    if (TDengineThingDataHelper.isArrayTerm(type, term)) {
                        term.setValue(TDengineThingDataHelper.tryConvertList(type, term));
                    } else if (type instanceof Converter) {
                        term.setValue(((Converter)type).convert(term.getValue()));
                    }
                });
            }
            term.setTerms(this.prepareTerms(metric, term.getTerms()));
        }
        return terms;
    }

    public static Object prepareTimestampValue(Object value, String type) {
        return ConverterUtils.tryConvertToList((Object)value, v -> {
            Date date = CastUtils.castDate((Object)v);
            return date.getTime();
        });
    }

    public static String buildOrderBy(QueryParamEntity param) {
        for (Sort sort : param.getSorts()) {
            if (!sort.getName().equalsIgnoreCase("timestamp")) continue;
            return " order by `_ts` " + sort.getOrder();
        }
        return " order by `_ts` desc";
    }

    public String buildWhere(String metric, QueryParamEntity param, String ... and) {
        StringJoiner joiner = new StringJoiner(" ", "where ", "");
        String sql = TDengineQueryConditionBuilder.build(this.prepareTerms(metric, param.getTerms()));
        if (StringUtils.hasText((String)sql)) {
            joiner.add(sql);
        }
        if (StringUtils.hasText((String)sql) && and.length > 0) {
            joiner.add("and");
        }
        for (int i = 0; i < and.length; ++i) {
            if (i > 0) {
                joiner.add("and");
            }
            joiner.add(and[i]);
        }
        return joiner.length() == 6 ? "" : joiner.toString();
    }

    public Flux<TimeSeriesData> query(String sql) {
        return this.operations.forQuery().query(sql, ResultWrappers.map()).mapNotNull(TDengineThingDataHelper::convertToTsData);
    }

    protected Flux<TimeSeriesData> doQuery(String metric, Query<?, QueryParamEntity> query) {
        QueryParamEntity param = (QueryParamEntity)query.getParam();
        StringJoiner joiner = new StringJoiner("");
        joiner.add("select * from").add(" `").add(metric).add("` ").add(this.buildWhere(metric, param, new String[0])).add(TDengineThingDataHelper.buildOrderBy(param));
        if (param.isPaging()) {
            joiner.add(" limit ").add(String.valueOf(param.getPageSize())).add(" offset ").add(String.valueOf(param.getPageSize() * param.getPageIndex()));
        }
        return this.operations.forQuery().query(joiner.toString(), ResultWrappers.map()).mapNotNull(TDengineThingDataHelper::convertToTsData);
    }

    public static TimeSeriesData convertToTsData(Map<String, Object> map) {
        Date ts = TDengineThingDataHelper.convertTs(map.remove("_ts"));
        return TimeSeriesData.of((Date)ts, map);
    }

    protected <T> Mono<PagerResult<T>> doQueryPage(String metric, Query<?, QueryParamEntity> query, Function<TimeSeriesData, T> mapper) {
        QueryParamEntity param = (QueryParamEntity)query.getParam();
        String sql = "`" + metric + "` " + this.buildWhere(metric, param, new String[0]);
        String countSql = "select count(1) total from " + sql;
        String dataSql = "select * from " + sql + TDengineThingDataHelper.buildOrderBy(param) + " limit " + param.getPageSize() + " offset " + param.getPageIndex() * param.getPageSize();
        return Mono.zip((Mono)this.operations.forQuery().query(countSql, ResultWrappers.map()).singleOrEmpty().map(data -> CastUtils.castNumber((Object)data.getOrDefault("total", 0)).intValue()).defaultIfEmpty((Object)0), (Mono)this.operations.forQuery().query(dataSql, ResultWrappers.map()).mapNotNull(map -> mapper.apply(TDengineThingDataHelper.convertToTsData(map))).collectList(), (total, data) -> PagerResult.of((int)total, (List)data, (QueryParam)param));
    }

    private static Date convertTs(Object ts) {
        if (ts == null) {
            throw new IllegalArgumentException();
        }
        if (ts instanceof Number) {
            return new Date(((Number)ts).longValue());
        }
        return DateTime.parse((String)String.valueOf(ts)).toDate();
    }

    public void applyValue(Point builder, String metric, String key, Object value, Predicate3<String, String, Object> tagTest) {
        if (value == null) {
            return;
        }
        if (tagTest.test((Object)metric, (Object)key, value)) {
            builder.tag(key, String.valueOf(value));
        } else if (value instanceof Number) {
            builder.value(key, ((Number)value).doubleValue());
        } else if (value instanceof Date) {
            builder.value(key, ((Date)value).getTime());
        } else if (value instanceof String) {
            builder.value(key, String.valueOf(value));
        } else {
            builder.value(key, ObjectMappers.toJsonString((Object)value));
        }
    }

    public Point convertToPoint(String metric, TimeSeriesData data, Predicate3<String, String, Object> tagTest) {
        Point point = Point.of(metric, null).timestamp(data.getTimestamp());
        for (Map.Entry entry : data.values().entrySet()) {
            this.applyValue(point, metric, (String)entry.getKey(), entry.getValue(), tagTest);
        }
        return point;
    }

    public Mono<Void> doSave(String metric, TimeSeriesData data, Predicate3<String, String, Object> tagTest) {
        return this.operations.forWrite().write(this.convertToPoint(metric, data, tagTest));
    }

    public Mono<Void> doSave(String metric, Flux<TimeSeriesData> dataFlux, Predicate3<String, String, Object> tagTest) {
        return this.operations.forWrite().write((Flux<Point>)dataFlux.map(data -> this.convertToPoint(metric, (TimeSeriesData)data, tagTest)));
    }

    public void dispose() {
        this.operations.dispose();
    }

    public TDengineThingDataHelper(TDengineOperations operations, MetricMetadataManager metadataManager) {
        this.operations = operations;
        this.metadataManager = metadataManager;
    }

    static {
        DateFormatter.supportFormatter.add(new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.+"), "yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        format = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    }
}

