/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.metadata;

import java.util.ArrayList;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;

public class TDengineCreateTableSqlBuilder
implements CreateTableSqlBuilder {
    public SqlRequest build(RDBTableMetadata table) {
        PrepareSqlFragments sql = PrepareSqlFragments.of();
        ArrayList columns = new ArrayList(table.getColumns().size());
        sql.addSql(new String[]{"CREATE STABLE IF NOT EXISTS", table.getFullName(), "("}).addSql(new String[]{"_ts timestamp"});
        ArrayList<RDBColumnMetadata> tags = new ArrayList<RDBColumnMetadata>();
        for (RDBColumnMetadata column : table.getColumns()) {
            if (column.getProperty("ts").isTrue()) continue;
            if (column.getProperty("tag").isTrue()) {
                tags.add(column);
                continue;
            }
            sql.addSql(new String[]{","}).addSql(new String[]{column.getQuoteName()}).addSql(new String[]{column.getDataType()});
        }
        sql.addSql(new String[]{")"});
        if (!tags.isEmpty()) {
            sql.addSql(new String[]{"TAGS ("});
            int index = 0;
            for (RDBColumnMetadata tag : tags) {
                if (index++ > 0) {
                    sql.addSql(new String[]{","});
                }
                sql.addSql(new String[]{tag.getQuoteName()}).addSql(new String[]{tag.getDataType()});
            }
            sql.addSql(new String[]{")"});
        }
        return sql.toRequest();
    }
}

