/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine;

import io.netty.util.internal.ThreadLocalRandom;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.jetlinks.community.buffer.BufferProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@ConfigurationProperties(prefix="tdengine")
public class TDengineProperties {
    @NotBlank
    private String database;
    private Connector connector = Connector.restful;
    private RestfulConnector restful = new RestfulConnector();
    private Buffer buffer = new Buffer();

    public String getDatabase() {
        return this.database;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public RestfulConnector getRestful() {
        return this.restful;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setRestful(RestfulConnector restful) {
        this.restful = restful;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public static class RestfulConnector {
        private List<URI> endpoints = new ArrayList<URI>(Collections.singletonList(URI.create("http://localhost:6041/")));
        private String username = "root";
        private String password = "taosdata";
        private int maxConnections = Runtime.getRuntime().availableProcessors() * 8;
        private Duration pendingAcquireTimeout = Duration.ofSeconds(10L);
        private Duration evictInBackground = Duration.ofSeconds(60L);
        private Duration connectionTimeout = Duration.ofSeconds(5L);
        private Duration socketTimeout = Duration.ofSeconds(5L);
        private DataSize maxInMemorySize = DataSize.ofMegabytes((long)10L);

        public URI selectURI() {
            return this.endpoints.get(ThreadLocalRandom.current().nextInt(this.endpoints.size()));
        }

        public WebClient createClient() {
            WebClient.Builder builder = WebClient.builder();
            URI endpoint = this.endpoints.get(0);
            if (this.endpoints.size() > 1) {
                builder = builder.filter((request, next) -> {
                    URI target = this.selectURI();
                    if (target.equals(endpoint)) {
                        return next.exchange(request);
                    }
                    URI uri = UriComponentsBuilder.fromUri((URI)request.url()).host(target.getHost()).port(target.getPort()).build().toUri();
                    return next.exchange(ClientRequest.from((ClientRequest)request).url(uri).build());
                });
            }
            return builder.codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize((int)this.maxInMemorySize.toBytes())).defaultHeaders(headers -> {
                if (StringUtils.hasText((String)this.username)) {
                    headers.setBasicAuth(this.username, this.password);
                }
            }).baseUrl(endpoint.toString()).build();
        }

        public List<URI> getEndpoints() {
            return this.endpoints;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public Duration getPendingAcquireTimeout() {
            return this.pendingAcquireTimeout;
        }

        public Duration getEvictInBackground() {
            return this.evictInBackground;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public Duration getSocketTimeout() {
            return this.socketTimeout;
        }

        public DataSize getMaxInMemorySize() {
            return this.maxInMemorySize;
        }

        public void setEndpoints(List<URI> endpoints) {
            this.endpoints = endpoints;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public void setPendingAcquireTimeout(Duration pendingAcquireTimeout) {
            this.pendingAcquireTimeout = pendingAcquireTimeout;
        }

        public void setEvictInBackground(Duration evictInBackground) {
            this.evictInBackground = evictInBackground;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public void setMaxInMemorySize(DataSize maxInMemorySize) {
            this.maxInMemorySize = maxInMemorySize;
        }
    }

    public static class Buffer
    extends BufferProperties {
        private boolean enabled = true;

        public Buffer() {
            this.setFilePath("./data/tdengine-buffer");
            this.setSize(3000);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    static enum Connector {
        restful;

    }
}

