/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene.term;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.PropertyMetadataConstants;
import org.jetlinks.community.PropertyMetric;
import org.jetlinks.community.reactorql.term.TermType;
import org.jetlinks.community.reactorql.term.TermTypes;
import org.jetlinks.community.rule.engine.scene.DeviceOperation;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.EnumType;
import org.springframework.util.StringUtils;

public class TermColumn {
    @Schema(description="\u6761\u4ef6\u5217")
    private String column;
    @Schema(description="\u540d\u79f0")
    private String name;
    @Schema(description="\u5168\u540d")
    private String fullName;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u6570\u636e\u7c7b\u578b")
    private String dataType;
    @Schema(description="\u662f\u5426\u4e3a\u7269\u6a21\u578b\u5217")
    private boolean metadata;
    @Schema(description="\u652f\u6301\u7684\u6761\u4ef6\u7c7b\u578b")
    private List<TermType> termTypes;
    @Schema(description="\u652f\u6301\u7684\u6307\u6807")
    private List<PropertyMetric> metrics;
    @Schema(description="\u53ef\u9009\u5185\u5bb9")
    private List<PropertyMetric> options;
    @Schema(description="\u5b50\u5217,\u5728\u7c7b\u578b\u4e3aobject\u65f6\u6709\u503c")
    private List<TermColumn> children;

    public TermColumn withMetadataTrue() {
        this.metadata = true;
        return this;
    }

    public TermColumn copyColumn(Predicate<String> childrenPredicate) {
        TermColumn copy = (TermColumn)FastBeanCopier.copy((Object)this, (Object)new TermColumn(), (String[])new String[0]);
        if (CollectionUtils.isNotEmpty(this.children)) {
            copy.setChildren(this.children.stream().filter(child -> childrenPredicate.test(child.getColumn())).map(child -> child.copyColumn(childrenPredicate)).collect(Collectors.toList()));
        }
        return copy;
    }

    public boolean hasColumn(Collection<String> columns) {
        for (String column : columns) {
            if (!this.hasColumn(column)) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String column) {
        if (this.column.equals(column)) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        for (TermColumn child : this.children) {
            if (!child.hasColumn(column)) continue;
            return true;
        }
        return false;
    }

    public String getVariable(CharSequence delimiter) {
        if (this.column == null) {
            return null;
        }
        String[] arr = this.column.split("[.]");
        if (arr.length == 1) {
            return arr[0];
        }
        return String.join(delimiter, Arrays.copyOfRange(arr, 1, arr.length));
    }

    @JsonIgnore
    public String getPropertyOrNull() {
        if (this.column == null) {
            return null;
        }
        if (!this.column.startsWith("properties")) {
            return null;
        }
        String[] arr = this.column.split("[.]");
        return arr[1];
    }

    public PropertyMetric getMetricOrNull(String metric) {
        if (this.metrics == null) {
            return null;
        }
        for (PropertyMetric propertyMetric : this.metrics) {
            if (!Objects.equals(propertyMetric.getId(), metric)) continue;
            return propertyMetric;
        }
        return null;
    }

    public TermColumn with(PropertyMetadata metadata) {
        this.setColumn(metadata.getId());
        this.setName(metadata.getName());
        this.setDataType(metadata.getValueType().getId());
        this.withMetrics(metadata);
        this.setTermTypes(TermTypes.lookup((DataType)metadata.getValueType()));
        return this;
    }

    public TermColumn withMetrics(PropertyMetadata metadata) {
        return this.withMetrics(PropertyMetadataConstants.Metrics.getMetrics((PropertyMetadata)metadata));
    }

    public TermColumn withMetrics(List<PropertyMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public static TermColumn of(String column, String name, DataType type) {
        return TermColumn.of(column, name, type, null);
    }

    public static TermColumn of(String column, String name, DataType type, String description) {
        List elements;
        TermColumn termColumn = new TermColumn();
        termColumn.setColumn(column);
        termColumn.setName(name);
        termColumn.setDataType(type.getId());
        termColumn.setDescription(description);
        termColumn.setTermTypes(TermTypes.lookup((DataType)type));
        if (type instanceof EnumType && CollectionUtils.isNotEmpty((Collection)(elements = ((EnumType)type).getElements()))) {
            ArrayList<PropertyMetric> options = new ArrayList<PropertyMetric>(elements.size());
            for (EnumType.Element element : elements) {
                options.add(PropertyMetric.of((String)element.getValue(), (String)element.getText(), null));
            }
            termColumn.setOptions(options);
        }
        return termColumn;
    }

    public static TermColumn of(PropertyMetadata metadata) {
        return new TermColumn().with(metadata);
    }

    public void refactorDescription(Function<String, TermColumn> columnGetter) {
        if (!StringUtils.hasText((String)this.description)) {
            this.doRefactorDescription(columnGetter);
        }
        if (this.children != null) {
            for (TermColumn child : this.children) {
                child.refactorDescription(columnGetter);
            }
        }
    }

    public void doRefactorDescription(Function<String, TermColumn> columnGetter) {
        if (CollectionUtils.isNotEmpty(this.children)) {
            return;
        }
        if (this.column.startsWith("properties")) {
            String[] arr = this.column.split("[.]");
            if (arr.length > 3) {
                TermColumn column = columnGetter.apply(arr[1]);
                String type = arr[arr.length - 1];
                this.setDescription(DeviceOperation.PropertyValueType.valueOf(type).getNestDescription(column.name));
            } else {
                String type = arr[arr.length - 1];
                this.setDescription(DeviceOperation.PropertyValueType.valueOf(type).getDescription());
            }
        }
    }

    public void refactorFullName(String parentName) {
        this.fullName = StringUtils.hasText((String)parentName) ? parentName + "/" + this.name : this.name;
        if (CollectionUtils.isNotEmpty(this.children)) {
            for (TermColumn child : this.children) {
                child.refactorFullName(this.fullName);
            }
        }
    }

    public String getColumn() {
        return this.column;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public List<TermType> getTermTypes() {
        return this.termTypes;
    }

    public List<PropertyMetric> getMetrics() {
        return this.metrics;
    }

    public List<PropertyMetric> getOptions() {
        return this.options;
    }

    public List<TermColumn> getChildren() {
        return this.children;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public void setTermTypes(List<TermType> termTypes) {
        this.termTypes = termTypes;
    }

    public void setMetrics(List<PropertyMetric> metrics) {
        this.metrics = metrics;
    }

    public void setOptions(List<PropertyMetric> options) {
        this.options = options;
    }

    public void setChildren(List<TermColumn> children) {
        this.children = children;
    }
}

