/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.jetlinks.community.PropertyMetric;
import org.jetlinks.community.rule.engine.scene.Variable;
import org.jetlinks.community.rule.engine.scene.term.TermColumn;
import org.jetlinks.community.rule.engine.scene.value.TermValue;
import org.springframework.util.StringUtils;

public class SceneUtils {
    public static List<Variable> parseVariable(List<Term> terms, List<TermColumn> columns) {
        Map<String, Term> termCache = SceneUtils.expandTerm(terms);
        ArrayList<Variable> variables = new ArrayList<Variable>(termCache.size());
        for (TermColumn column : columns) {
            variables.addAll(SceneUtils.columnToVariable(null, column, termCache::get));
        }
        return variables;
    }

    public static Map<String, Term> expandTerm(List<Term> terms) {
        LinkedHashMap<String, Term> termCache = new LinkedHashMap<String, Term>();
        SceneUtils.expandTerm(terms, termCache);
        return termCache;
    }

    private static void expandTerm(List<Term> terms, Map<String, Term> container) {
        if (terms == null) {
            return;
        }
        for (Term term : terms) {
            if (StringUtils.hasText((String)term.getColumn())) {
                container.put(term.getColumn(), term);
            }
            if (term.getTerms() == null) continue;
            SceneUtils.expandTerm(term.getTerms(), container);
        }
    }

    private static List<Variable> columnToVariable(String prefixName, TermColumn column, Function<String, Term> termSupplier) {
        ArrayList<Variable> variables;
        block3: {
            block2: {
                variables = new ArrayList<Variable>(1);
                String variableName = column.getName();
                if (!CollectionUtils.isEmpty(column.getChildren())) break block2;
                Term term = termSupplier.apply(column.getColumn());
                variables.add(Variable.of(column.getVariable("_"), variableName).with(column));
                if (term == null) break block3;
                List<TermValue> termValues = TermValue.of(term);
                String property = column.getPropertyOrNull();
                for (TermValue termValue : termValues) {
                    PropertyMetric metric = column.getMetricOrNull(termValue.getMetric());
                    if (property == null || metric == null || termValue.getSource() != TermValue.Source.metric) continue;
                    variables.add(Variable.of(property + "_metric_" + termValue.getMetric(), (prefixName == null ? column.getName() : prefixName) + "_\u6307\u6807_" + metric.getName()).withTermType(column.getTermTypes()).withColumn(column.getColumn()).withMetadata(column.isMetadata()));
                }
                break block3;
            }
            Variable variable = Variable.of(column.getColumn(), column.getName());
            ArrayList<Variable> children = new ArrayList<Variable>();
            variable.setChildren(children);
            variable.with(column);
            variables.add(variable);
            for (TermColumn child : column.getChildren()) {
                children.addAll(SceneUtils.columnToVariable(column.getName(), child, termSupplier));
            }
        }
        return variables;
    }
}

