/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.measurement;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hswebframework.ezorm.core.dsl.Query;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.rule.engine.measurement.AlarmTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import reactor.core.publisher.Flux;

public class AlarmRecordTrendMeasurement
extends StaticMeasurement {
    TimeSeriesManager timeSeriesManager;
    static ConfigMetadata aggConfigMetadata = new DefaultConfigMetadata().add("alarmConfigId", "\u544a\u8b66\u914d\u7f6eId", "", (DataType)StringType.GLOBAL).add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)StringType.GLOBAL).add("agg", "\u805a\u5408\u7c7b\u578b", "count,sum,avg,max,min", (DataType)StringType.GLOBAL).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)StringType.GLOBAL).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)StringType.GLOBAL).add("from", "\u65f6\u95f4\u4ece", "", (DataType)StringType.GLOBAL).add("to", "\u65f6\u95f4\u81f3", "", (DataType)StringType.GLOBAL);

    public AlarmRecordTrendMeasurement(TimeSeriesManager timeSeriesManager) {
        super(MeasurementDefinition.of((String)"trend", (String)"\u544a\u8b66\u8bb0\u5f55\u8d8b\u52bf"));
        this.timeSeriesManager = timeSeriesManager;
        this.addDimension(new AggRecordTrendDimension());
    }

    class AggRecordTrendDimension
    implements MeasurementDimension {
        AggRecordTrendDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return IntType.GLOBAL;
        }

        public ConfigMetadata getParams() {
            return aggConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public AggregationQueryParam createQueryParam(MeasurementParameter parameter) {
            return AggregationQueryParam.of().groupBy(parameter.getInterval("time", null), parameter.getString("format").orElse("MM\u6708dd\u65e5 HH\u65f6")).sum("count", "count").filter(query -> {
                Query cfr_ignored_0 = (Query)((Query)((Query)((Query)query.where("name", (Object)"record-agg")).and("targetType", parameter.getString("targetType").orElse(null))).and("targetId", parameter.getString("targetId").orElse(null))).is("alarmConfigId", parameter.getString("alarmConfigId").orElse(null));
            }).limit(parameter.getInt("limit").orElse(1).intValue()).from(parameter.getDate("from").orElseGet(() -> Date.from(LocalDateTime.now().plusDays(-1L).atZone(ZoneId.systemDefault()).toInstant()))).to(parameter.getDate("to").orElse(new Date()));
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            AggregationQueryParam param = this.createQueryParam(parameter);
            return Flux.defer(() -> ((Flux)param.execute(arg_0 -> ((TimeSeriesService)AlarmRecordTrendMeasurement.this.timeSeriesManager.getService(AlarmTimeSeriesMetric.alarmStreamMetrics())).aggregation(arg_0))).index((index, data) -> SimpleMeasurementValue.of((Object)data.getLong("count", 0L), (String)data.getString("time", ""), (long)index))).take((long)param.getLimit());
        }
    }
}

