/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor.device;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.community.rule.engine.executor.device.CompositeDeviceSelectorProvider;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProvider;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorSpec;
import org.jetlinks.community.rule.engine.executor.device.SelectorValue;
import org.jetlinks.community.rule.engine.executor.device.SimpleDeviceSelectorProvider;
import org.jetlinks.reactor.ql.utils.CastUtils;

public class DeviceSelectorProviders {
    private static final Map<String, DeviceSelectorProvider> providers = new LinkedHashMap<String, DeviceSelectorProvider>();
    public static final String PROVIDER_FIXED = "fixed";
    public static final String PROVIDER_CONTEXT = "context";
    public static final String PROVIDER_PRODUCT = "product";
    public static final String PROVIDER_TAG = "tag";

    public static boolean isFixed(DeviceSelectorSpec spec) {
        return PROVIDER_FIXED.equals(spec.getSelector()) || PROVIDER_CONTEXT.equals(spec.getSelector());
    }

    public static DeviceSelectorSpec fixed(Object value) {
        DeviceSelectorSpec spec = new DeviceSelectorSpec();
        spec.setSelector(PROVIDER_CONTEXT);
        spec.setSource(VariableSource.Source.fixed);
        spec.setValue(value);
        return spec;
    }

    public static DeviceSelectorSpec product(String productId) {
        DeviceSelectorSpec spec = new DeviceSelectorSpec();
        spec.setSelector(PROVIDER_PRODUCT);
        spec.setSource(VariableSource.Source.fixed);
        spec.setValue(productId);
        return spec;
    }

    public static DeviceSelectorSpec composite(Collection<DeviceSelectorSpec> specs) {
        DeviceSelectorSpec composite = new DeviceSelectorSpec();
        composite.setSource(VariableSource.Source.fixed);
        composite.setSelector("composite");
        composite.setSelectorValues(specs.stream().map(spec -> SelectorValue.of(spec, null)).collect(Collectors.toList()));
        return composite;
    }

    public static DeviceSelectorSpec composite(DeviceSelectorSpec ... specs) {
        return DeviceSelectorProviders.composite(Arrays.asList(specs));
    }

    public static void register(DeviceSelectorProvider provider) {
        providers.put(provider.getProvider(), provider);
    }

    public static Optional<DeviceSelectorProvider> getProvider(String provider) {
        return Optional.ofNullable(providers.get(provider));
    }

    public static DeviceSelectorProvider getProviderNow(String provider) {
        return DeviceSelectorProviders.getProvider(provider).orElseThrow(() -> new UnsupportedOperationException("unsupported device selector provider:" + provider));
    }

    public static List<DeviceSelectorProvider> allProvider() {
        return new ArrayList<DeviceSelectorProvider>(providers.values());
    }

    static {
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of("all", "\u5168\u90e8\u8bbe\u5907", (args, query) -> query));
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of(PROVIDER_FIXED, "\u56fa\u5b9a\u8bbe\u5907", (args, query) -> query.in("id", (Collection)args)));
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of(PROVIDER_CONTEXT, "\u5185\u7f6e\u53c2\u6570", (args, query) -> query.in("id", (Collection)args)));
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of("state", "\u6309\u72b6\u6001", (args, query) -> query.in("state", (Collection)args)));
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of(PROVIDER_PRODUCT, "\u6309\u4ea7\u54c1", (args, query) -> query.in("productId", (Collection)args)));
        DeviceSelectorProviders.register(SimpleDeviceSelectorProvider.of(PROVIDER_TAG, "\u6309\u6807\u7b7e", (args, query) -> {
            if (args.size() == 1) {
                return query.accept("id", "dev-tag", args.get(0));
            }
            LinkedHashMap tagsMap = Maps.newLinkedHashMapWithExpectedSize((int)args.size());
            ArrayList temp = new ArrayList(args.size());
            for (Object val : args) {
                if (val instanceof Map) {
                    tagsMap.putAll((Map)val);
                    continue;
                }
                if (val instanceof String) {
                    String[] arr = String.valueOf(val).split(":");
                    if (arr.length != 2) continue;
                    tagsMap.put(arr[0], arr[1]);
                    continue;
                }
                temp.add(val);
            }
            if (CollectionUtils.isNotEmpty(temp)) {
                tagsMap.putAll(CastUtils.castMap(temp));
            }
            return query.accept("id", "dev-tag", (Object)tagsMap);
        }));
        DeviceSelectorProviders.register(new CompositeDeviceSelectorProvider());
    }
}

