/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.utils.TemplateParser;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.community.rule.engine.executor.DeviceSelectorBuilder;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProviders;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorSpec;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.reactor.ql.supports.DefaultPropertyFeature;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.RuleDataHelper;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.FunctionTaskExecutor;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Component
public class DeviceMessageSendTaskExecutorProvider
implements TaskExecutorProvider {
    public static final String EXECUTOR = "device-message-sender";
    private final DeviceRegistry registry;
    private final DeviceSelectorBuilder selectorBuilder;

    public String getExecutor() {
        return EXECUTOR;
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)((Object)new DeviceMessageSendTaskExecutor(context)));
    }

    public DeviceMessageSendTaskExecutorProvider(DeviceRegistry registry, DeviceSelectorBuilder selectorBuilder) {
        this.registry = registry;
        this.selectorBuilder = selectorBuilder;
    }

    public static class DeviceMessageSendConfig {
        private String deviceId;
        private String productId;
        private DeviceSelectorSpec selectorSpec;
        private String from;
        private Duration timeout = Duration.ofSeconds(10L);
        private Map<String, Object> message;
        private boolean async;
        private String waitType = "sync";
        private String stateOperator = "ignoreOffline";
        private long delayMillis = 0L;
        private Map<String, Object> responseHeaders;

        public Map<String, Object> toMap() {
            Map conf = (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]);
            conf.put("timeout", this.timeout.toString());
            return conf;
        }

        public Flux<DeviceMessage> doSend(Map<String, Object> ctx, ExecutionContext context, DeviceOperator device, RuleData input) {
            HashMap<String, Object> message = new HashMap<String, Object>("pre-node".equals(this.from) ? ctx : this.message);
            message.put("messageId", IDGenerator.SNOW_FLAKE_STRING.generate());
            message.put("deviceId", device.getDeviceId());
            message.put("timestamp", System.currentTimeMillis());
            return ((Mono)Mono.justOrEmpty((Optional)MessageType.convertMessage(message)).switchIfEmpty(context.onError(() -> new DeviceOperationException(ErrorCode.UNSUPPORTED_MESSAGE), input)).cast(DeviceMessage.class).flatMap(msg -> this.applyMessageExpression(ctx, (DeviceMessage)msg)).doOnNext(msg -> msg.addHeader(Headers.async, (Object)(this.async || !"sync".equals(this.waitType) ? 1 : 0)).addHeader(Headers.sendAndForget, (Object)"forget".equals(this.waitType)).addHeader(Headers.timeout, (Object)this.timeout.toMillis())).as(mono -> {
                if (this.delayMillis > 0L) {
                    return mono.delayElement(Duration.ofMillis(this.delayMillis));
                }
                return mono;
            })).flatMapMany(msg -> "forget".equals(this.waitType) ? device.messageSender().send(msg).then(Mono.empty()) : device.messageSender().send(msg).onErrorResume(err -> {
                if (msg instanceof RepayableDeviceMessage) {
                    return Mono.just((Object)((RepayableDeviceMessage)msg).newReply().error(err));
                }
                return Mono.error((Throwable)err);
            }));
        }

        private Mono<ReadPropertyMessage> applyMessageExpression(Map<String, Object> ctx, ReadPropertyMessage message) {
            return Mono.just((Object)message);
        }

        private Mono<WritePropertyMessage> applyMessageExpression(Map<String, Object> ctx, WritePropertyMessage message) {
            Map properties = message.getProperties();
            if (!CollectionUtils.isEmpty((Map)properties)) {
                message.setProperties(Maps.transformValues((Map)properties, v -> VariableSource.of((Object)v).resolveStatic(ctx)));
            }
            return Mono.just((Object)message);
        }

        private Mono<FunctionInvokeMessage> applyMessageExpression(Map<String, Object> ctx, FunctionInvokeMessage message) {
            List inputs = message.getInputs();
            if (!CollectionUtils.isEmpty((Collection)inputs)) {
                return Flux.fromIterable((Iterable)inputs).flatMap(param -> VariableSource.of((Object)param.getValue()).resolve(ctx).doOnNext(arg_0 -> ((FunctionParameter)param).setValue(arg_0))).then(Mono.just((Object)message));
            }
            return Mono.just((Object)message);
        }

        private String getDeviceIdInMessage(Map<String, Object> ctx) {
            String deviceId = (String)this.message.get("deviceId");
            if (StringUtils.hasText((String)deviceId)) {
                if (deviceId.contains("${")) {
                    return TemplateParser.parse((String)deviceId, var -> DefaultPropertyFeature.GLOBAL.getProperty(var, (Object)ctx).map(String::valueOf).orElse(""));
                }
                return deviceId;
            }
            return null;
        }

        private Mono<? extends DeviceMessage> applyMessageExpression(Map<String, Object> ctx, DeviceMessage message) {
            if (message instanceof ReadPropertyMessage) {
                return this.applyMessageExpression(ctx, (ReadPropertyMessage)message);
            }
            if (message instanceof WritePropertyMessage) {
                return this.applyMessageExpression(ctx, (WritePropertyMessage)message);
            }
            if (message instanceof FunctionInvokeMessage) {
                return this.applyMessageExpression(ctx, (FunctionInvokeMessage)message);
            }
            return Mono.just((Object)message);
        }

        private boolean isFixed() {
            return "fixed".equals(this.from);
        }

        private boolean isPreNode() {
            return "pre-node".equals(this.from);
        }

        public void validate() {
            if ("fixed".equals(this.from)) {
                MessageType.convertMessage(this.message).orElseThrow(() -> new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u683c\u5f0f"));
            }
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getProductId() {
            return this.productId;
        }

        public DeviceSelectorSpec getSelectorSpec() {
            return this.selectorSpec;
        }

        public String getFrom() {
            return this.from;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Map<String, Object> getMessage() {
            return this.message;
        }

        public boolean isAsync() {
            return this.async;
        }

        public String getWaitType() {
            return this.waitType;
        }

        public String getStateOperator() {
            return this.stateOperator;
        }

        public long getDelayMillis() {
            return this.delayMillis;
        }

        public Map<String, Object> getResponseHeaders() {
            return this.responseHeaders;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public void setSelectorSpec(DeviceSelectorSpec selectorSpec) {
            this.selectorSpec = selectorSpec;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public void setMessage(Map<String, Object> message) {
            this.message = message;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }

        public void setWaitType(String waitType) {
            this.waitType = waitType;
        }

        public void setStateOperator(String stateOperator) {
            this.stateOperator = stateOperator;
        }

        public void setDelayMillis(long delayMillis) {
            this.delayMillis = delayMillis;
        }

        public void setResponseHeaders(Map<String, Object> responseHeaders) {
            this.responseHeaders = responseHeaders;
        }
    }

    class DeviceMessageSendTaskExecutor
    extends FunctionTaskExecutor {
        private DeviceMessageSendConfig config;
        private Function<Map<String, Object>, Flux<DeviceOperator>> selector;

        public DeviceMessageSendTaskExecutor(ExecutionContext context) {
            super("\u53d1\u9001\u8bbe\u5907\u6d88\u606f", context);
            this.reload();
        }

        protected Flux<DeviceOperator> selectDevice(Map<String, Object> ctx) {
            return this.selector.apply(ctx);
        }

        protected Publisher<RuleData> apply(RuleData input) {
            Map ctx = RuleDataHelper.toContextMap((RuleData)input);
            Flux readySendDevice = "ignoreOffline".equals(this.config.getStateOperator()) ? this.selectDevice(ctx).filterWhen(DeviceOperator::isOnline) : this.selectDevice(ctx);
            return readySendDevice.switchIfEmpty((Publisher)this.context.onError(() -> new DeviceOperationException(ErrorCode.SYSTEM_ERROR, "\u65e0\u53ef\u7528\u8bbe\u5907"), input)).flatMap(device -> this.config.doSend(ctx, this.context, (DeviceOperator)device, input).onErrorResume(error -> this.context.onError(error, input)).subscribeOn(Schedulers.parallel())).map(reply -> {
                RuleData data = this.context.newRuleData((Object)input.newData((Object)reply.toJson()));
                if (this.config.getResponseHeaders() != null) {
                    this.config.getResponseHeaders().forEach((arg_0, arg_1) -> ((RuleData)data).setHeader(arg_0, arg_1));
                }
                return data;
            });
        }

        public void validate() {
            if (CollectionUtils.isEmpty((Map)this.context.getJob().getConfiguration())) {
                throw new IllegalArgumentException("\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ((DeviceMessageSendConfig)FastBeanCopier.copy((Object)this.context.getJob().getConfiguration(), (Object)new DeviceMessageSendConfig(), (String[])new String[0])).validate();
        }

        public void reload() {
            this.config = (DeviceMessageSendConfig)FastBeanCopier.copy((Object)this.context.getJob().getConfiguration(), (Object)new DeviceMessageSendConfig(), (String[])new String[0]);
            this.config.validate();
            this.selector = this.config.getSelectorSpec() != null ? DeviceMessageSendTaskExecutorProvider.this.selectorBuilder.createSelector(this.config.getSelectorSpec())::select : (StringUtils.hasText((String)this.config.deviceId) ? ctx -> DeviceMessageSendTaskExecutorProvider.this.registry.getDevice(this.config.getDeviceId()).flux() : (StringUtils.hasText((String)this.config.productId) ? DeviceMessageSendTaskExecutorProvider.this.selectorBuilder.createSelector(DeviceSelectorProviders.product(this.config.productId))::select : (this.config.isFixed() && MapUtils.isNotEmpty(this.config.getMessage()) ? ctx -> DeviceMessageSendTaskExecutorProvider.this.registry.getDevice(this.config.getDeviceIdInMessage(ctx)).flux() : ctx -> DeviceMessageSendTaskExecutorProvider.this.registry.getDevice((String)ctx.getOrDefault("deviceId", this.config.getMessage() == null ? null : this.config.getMessage().get("deviceId"))).flux())));
        }
    }
}

