/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.voice.aliyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.logger.ReactiveLogger;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.voice.VoiceProvider;
import org.jetlinks.community.notify.voice.aliyun.AliyunVoiceTemplate;
import org.jetlinks.core.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AliyunVoiceNotifier
extends AbstractNotifier<AliyunVoiceTemplate> {
    private static final Logger log = LoggerFactory.getLogger(AliyunVoiceNotifier.class);
    private final IAcsClient client;
    private final int connectTimeout = 1000;
    private final int readTimeout = 5000;
    private String notifierId;
    private String domain = "dyvmsapi.aliyuncs.com";
    private String regionId = "cn-hangzhou";

    public AliyunVoiceNotifier(NotifierProperties profile, TemplateManager templateManager) {
        super(templateManager);
        Map config = profile.getConfiguration();
        this.regionId = (String)Objects.requireNonNull(config.get("regionId"), "regionId\u4e0d\u80fd\u4e3a\u7a7a");
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)this.regionId, (String)((String)Objects.requireNonNull(config.get("accessKeyId"), "accessKeyId\u4e0d\u80fd\u4e3a\u7a7a")), (String)((String)Objects.requireNonNull(config.get("secret"), "secret\u4e0d\u80fd\u4e3a\u7a7a")));
        this.client = new DefaultAcsClient((IClientProfile)defaultProfile);
        this.domain = config.getOrDefault("domain", "dyvmsapi.aliyuncs.com");
        this.notifierId = profile.getId();
    }

    public AliyunVoiceNotifier(IClientProfile profile, TemplateManager templateManager) {
        this((IAcsClient)new DefaultAcsClient(profile), templateManager);
    }

    public AliyunVoiceNotifier(IAcsClient client, TemplateManager templateManager) {
        super(templateManager);
        this.client = client;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.voice;
    }

    @Nonnull
    public Provider getProvider() {
        return VoiceProvider.aliyun;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull AliyunVoiceTemplate template, @Nonnull Values context) {
        return Mono.defer(() -> {
            try {
                CommonRequest request = new CommonRequest();
                request.setSysMethod(MethodType.POST);
                request.setSysDomain(this.domain);
                request.setSysVersion("2017-05-25");
                request.setSysAction("SingleCallByTts");
                request.setSysConnectTimeout(Integer.valueOf(1000));
                request.setSysReadTimeout(Integer.valueOf(5000));
                request.putQueryParameter("RegionId", this.regionId);
                request.putQueryParameter("CalledShowNumber", template.getCalledShowNumbers());
                request.putQueryParameter("CalledNumber", template.getCalledNumber(context.getAllValues()));
                request.putQueryParameter("TtsCode", template.getTtsCode());
                request.putQueryParameter("PlayTimes", String.valueOf(template.getPlayTimes()));
                request.putQueryParameter("TtsParam", template.createTtsParam(context.getAllValues()));
                CommonResponse response = this.client.getCommonResponse(request);
                log.info("\u53d1\u8d77\u8bed\u97f3\u901a\u77e5\u5b8c\u6210 {}:{}", (Object)response.getHttpResponse().getStatus(), (Object)response.getData());
                JSONObject json = JSON.parseObject((String)response.getData());
                if (!"ok".equalsIgnoreCase(json.getString("Code"))) {
                    return Mono.error((Throwable)new BusinessException(json.getString("Message"), json.getString("Code")));
                }
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            return Mono.empty();
        }).doOnEach(ReactiveLogger.onError(err -> log.info("\u53d1\u8d77\u8bed\u97f3\u901a\u77e5\u5931\u8d25", err))).subscribeOn(Schedulers.boundedElastic());
    }

    @Nonnull
    public Mono<Void> close() {
        return Mono.fromRunnable(() -> ((IAcsClient)this.client).shutdown());
    }

    public String getNotifierId() {
        return this.notifierId;
    }
}

