/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.entity;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.notify.event.SerializableNotifierEvent;
import org.jetlinks.community.notify.manager.enums.NotifyState;

@Table(name="notify_history", indexes={@Index(name="idx_nt_his_notifier_id", columnList="notifier_id")})
public class NotifyHistoryEntity
extends GenericEntity<String> {
    private static final long serialVersionUID = -6849794470754667710L;
    @Column(length=32, nullable=false, updatable=false)
    @Schema(description="\u901a\u77e5ID")
    private String notifierId;
    @Column(nullable=false)
    @DefaultValue(value="success")
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u72b6\u6001")
    private NotifyState state;
    @Column(length=1024)
    @Schema(description="\u9519\u8bef\u7c7b\u578b")
    private String errorType;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @Schema(description="\u5f02\u5e38\u6808")
    private String errorStack;
    @Column(length=32, nullable=false)
    @DefaultValue(value="-")
    @Schema(description="\u6a21\u7248ID")
    private String templateId;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @Schema(description="\u6a21\u7248\u5185\u5bb9")
    private String template;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @JsonCodec
    @Schema(description="\u4e0a\u4e0b\u6587")
    private Map<String, Object> context;
    @Column(length=32, nullable=false)
    @Schema(description="\u670d\u52a1\u5546")
    private String provider;
    @Column(length=32, nullable=false)
    @Schema(description="\u901a\u77e5\u7c7b\u578b")
    private String notifyType;
    @Column
    @DefaultValue(generator="current_time")
    @Schema(description="\u901a\u77e5\u65f6\u95f4")
    private Date notifyTime;
    @Column
    @DefaultValue(value="0")
    @Schema(description="\u91cd\u8bd5\u6b21\u6570")
    private Integer retryTimes;

    public static NotifyHistoryEntity of(SerializableNotifierEvent event) {
        NotifyHistoryEntity entity = (NotifyHistoryEntity)((Object)FastBeanCopier.copy((Object)event, (Object)((Object)new NotifyHistoryEntity()), (String[])new String[0]));
        if (null != event.getTemplate()) {
            entity.setTemplate(JSON.toJSONString((Object)event.getTemplate()));
        }
        if (event.isSuccess()) {
            entity.setState(NotifyState.success);
        } else {
            entity.setErrorStack(event.getCause());
            entity.setState(NotifyState.error);
        }
        return entity;
    }

    public String getNotifierId() {
        return this.notifierId;
    }

    public NotifyState getState() {
        return this.state;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorStack() {
        return this.errorStack;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public Date getNotifyTime() {
        return this.notifyTime;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public void setNotifierId(String notifierId) {
        this.notifierId = notifierId;
    }

    public void setState(NotifyState state) {
        this.state = state;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setErrorStack(String errorStack) {
        this.errorStack = errorStack;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public void setNotifyTime(Date notifyTime) {
        this.notifyTime = notifyTime;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }
}

