/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.io.file;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.jetlinks.community.io.file.FileOption;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class FileInfo {
    public static final String OTHER_ACCESS_KEY = "accessKey";
    private String id;
    private String name;
    private String extension;
    private long length;
    private String md5;
    private String sha256;
    private long createTime;
    private String creatorId;
    private FileOption[] options;
    private Map<String, Object> others;
    private String accessUrl;

    public void withBasePath(String apiBashPath) {
        if (!apiBashPath.endsWith("/")) {
            apiBashPath = apiBashPath + "/";
        }
        this.accessUrl = apiBashPath + "file/" + this.id + "?accessKey=" + this.accessKey().orElse("");
    }

    public MediaType mediaType() {
        if (!StringUtils.hasText((String)this.extension)) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        switch (this.extension.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                return MediaType.IMAGE_JPEG;
            }
            case "png": {
                return MediaType.IMAGE_PNG;
            }
            case "gif": {
                return MediaType.IMAGE_GIF;
            }
            case "mp4": {
                return MediaType.parseMediaType((String)"video/mp4");
            }
            case "flv": {
                return MediaType.parseMediaType((String)"video/x-flv");
            }
            case "text": 
            case "txt": {
                return MediaType.TEXT_PLAIN;
            }
            case "js": {
                return MediaType.APPLICATION_JSON;
            }
        }
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    public boolean hasOption(FileOption option) {
        if (this.options == null) {
            return false;
        }
        for (FileOption fileOption : this.options) {
            if (fileOption != option) continue;
            return true;
        }
        return false;
    }

    public FileInfo withFileName(String fileName) {
        this.name = fileName;
        this.extension = FilenameUtils.getExtension((String)fileName);
        return this;
    }

    public synchronized FileInfo withOther(String key, Object value) {
        if (this.others == null) {
            this.others = new HashMap<String, Object>();
        }
        this.others.put(key, value);
        return this;
    }

    public FileInfo withAccessKey(String accessKey) {
        this.withOther(OTHER_ACCESS_KEY, accessKey);
        return this;
    }

    public Optional<String> accessKey() {
        return Optional.ofNullable(this.others).map(map -> map.get(OTHER_ACCESS_KEY)).map(String::valueOf).filter(StringUtils::hasText);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public long getLength() {
        return this.length;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSha256() {
        return this.sha256;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public FileOption[] getOptions() {
        return this.options;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setOptions(FileOption[] options) {
        this.options = options;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }
}

